/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.OutputHandler;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfInboundMessageProcessor;
import org.mule.module.cxf.builder.WebServiceMessageProcessorBuilder;
import org.mule.module.cxf.testmodels.Echo;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class CxfInboundMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns1:echo xmlns:ns1=\"http://testmodels.cxf.module.mule.org/\"><text>echo</text></ns1:echo></soap:Body></soap:Envelope>";
    boolean gotEvent = false;
    Object payload;

    @Test
    public void testInbound() throws Exception {
        CxfInboundMessageProcessor processor = this.createCxfMessageProcessor();
        MessageProcessor messageProcessor = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                CxfInboundMessageProcessorTestCase.this.payload = event.getMessage().getPayload();
                Assert.assertEquals((Object)"echo", (Object)CxfInboundMessageProcessorTestCase.this.payload);
                event.getMessage().setPayload((Object)"echo");
                CxfInboundMessageProcessorTestCase.this.gotEvent = true;
                return event;
            }
        };
        processor.setListener(messageProcessor);
        MuleEvent event = CxfInboundMessageProcessorTestCase.getTestEvent((Object)this.msg, (InboundEndpoint)CxfInboundMessageProcessorTestCase.getTestInboundEndpoint((MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE));
        MuleEvent response = processor.process(event);
        Object payload = response.getMessage().getPayload();
        Assert.assertTrue((boolean)(payload instanceof OutputHandler));
        ((OutputHandler)payload).write(response, (OutputStream)System.out);
        Assert.assertTrue((boolean)this.gotEvent);
    }

    @Test
    public void testOneWay() throws Exception {
        CxfInboundMessageProcessor processor = this.createCxfMessageProcessor();
        MessageProcessor messageProcessor = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                CxfInboundMessageProcessorTestCase.this.payload = event.getMessage().getPayload();
                Assert.assertEquals((Object)"echo", (Object)CxfInboundMessageProcessorTestCase.this.payload);
                event.getMessage().setPayload((Object)"echo");
                CxfInboundMessageProcessorTestCase.this.gotEvent = true;
                return null;
            }
        };
        processor.setListener(messageProcessor);
        MuleEvent event = CxfInboundMessageProcessorTestCase.getTestEvent((Object)this.msg, (InboundEndpoint)CxfInboundMessageProcessorTestCase.getTestInboundEndpoint((MessageExchangePattern)MessageExchangePattern.ONE_WAY));
        MuleEvent response = processor.process(event);
        Assert.assertTrue((boolean)this.gotEvent);
        Assert.assertNull((Object)response);
    }

    private CxfInboundMessageProcessor createCxfMessageProcessor() throws MuleException {
        CxfConfiguration config = new CxfConfiguration();
        config.setMuleContext(muleContext);
        config.initialise();
        WebServiceMessageProcessorBuilder builder = new WebServiceMessageProcessorBuilder();
        builder.setConfiguration(config);
        builder.setServiceClass(Echo.class);
        builder.setMuleContext(muleContext);
        CxfInboundMessageProcessor processor = builder.build();
        processor.start();
        return processor;
    }
}

