/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.NullPayload;

public class CxfOutboundMessageProcessorPayloadTestCase
extends AbstractMuleContextTestCase {
    private CxfOutboundMessageProcessor cxfMP;
    private CxfConfiguration configuration;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.configuration = new CxfConfiguration();
        this.configuration.setMuleContext(muleContext);
        this.configuration.initialise();
        this.cxfMP = new CxfOutboundMessageProcessor(null);
    }

    @Test
    public void testGetArgs_withObjectAsPayload() throws Exception {
        Object payload = new Object();
        Object[] args = this.callGetArgsWithPayload(payload);
        Assert.assertNotNull((Object)args);
        Assert.assertEquals((long)1L, (long)args.length);
        Assert.assertSame((Object)payload, (Object)args[0]);
    }

    @Test
    public void testGetArgs_withArrayAsPayload() throws Exception {
        Object[] payload = new Object[4];
        Object[] args = this.callGetArgsWithPayload(payload);
        Assert.assertSame((Object)payload, (Object)args);
    }

    @Test
    public void testGetArgs_withNullPayloadAsPayload() throws Exception {
        NullPayload payload = NullPayload.getInstance();
        Object[] args = this.callGetArgsWithPayload(payload);
        Assert.assertNotNull((Object)args);
        Assert.assertEquals((long)1L, (long)args.length);
        Assert.assertSame((Object)payload, (Object)args[0]);
    }

    private Object[] callGetArgsWithPayload(Object payload) throws TransformerException {
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)muleEvent.getMessage()).thenReturn((Object)muleMessage);
        Mockito.when((Object)muleEvent.getMessage().getPayload()).thenReturn(payload);
        Mockito.when((Object)muleMessage.getPayload()).thenReturn(payload);
        Object[] args = this.cxfMP.getArgs(muleEvent);
        return args;
    }
}

