/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.module.cxf.testmodels.AsyncService;
import org.mule.module.cxf.testmodels.AsyncServiceWithSoapAction;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class ProxyTestCase
extends AbstractServiceAndFlowTestCase {
    String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><test xmlns=\"http://foo\"> foo </test></soap:Body></soap:Envelope>";
    String doGoogleSearch = "<urn:doGoogleSearch xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:urn=\"urn:GoogleSearch\">";
    String msgWithComment = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><!-- comment 1 --><soap:Header><!-- comment 2 --></soap:Header><!-- comment 3 --><soap:Body><!-- comment 4 -->" + this.doGoogleSearch + "<!-- this comment breaks it -->" + "<key>1</key>" + "<!-- comment 5 -->" + "<q>a</q>" + "<start>0</start>" + "<maxResults>1</maxResults>" + "<filter>false</filter>" + "<restrict>a</restrict>" + "<safeSearch>true</safeSearch>" + "<lr>a</lr>" + "<ie>b</ie>" + "<oe>c</oe>" + "</urn:doGoogleSearch>" + "<!-- comment 6 -->" + "</soap:Body>" + "<!-- comment 7 -->" + "</soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public ProxyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "proxy-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "proxy-conf-flow.xml"});
    }

    @Test
    public void testServerWithEcho() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo", (Object)this.msg, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("<test xmlns=\"http://foo\"> foo </test>") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testServerClientProxy() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <foo xmlns=\"http://foo\"></foo></soap:Body></soap:Envelope>";
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxy", (Object)msg, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("<foo xmlns=\"http://foo\"") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testProxyBodyValidation() throws Exception {
        this.doTestProxyValidation("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyBodyWithValidation");
    }

    @Test
    public void testProxyBodyValidationWithExternalSchema() throws Exception {
        this.doTestProxyValidation("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyBodyWithValidationAndSchemas");
    }

    @Test
    public void testProxyEnvelopeValidation() throws Exception {
        this.doTestProxyValidation("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyEnvelopeWithValidation");
    }

    public void doTestProxyValidation(String url) throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(url, (Object)this.msg, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("Schema validation error on message") != -1 ? 1 : 0) != 0);
        String valid = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <echo xmlns=\"http://www.muleumo.org\">  <echo>test</echo></echo></soap:Body></soap:Envelope>";
        result = client.send(url, (Object)valid, null);
        resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains("<echoResponse xmlns=\"http://www.muleumo.org\">"));
    }

    @Test
    public void testServerClientProxyWithWsdl() throws Exception {
        final Latch latch = new Latch();
        ((FunctionalTestComponent)this.getComponent("serverClientProxyWithWsdl")).setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch.countDown();
            }
        });
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyWithWsdl", (Object)msg, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((resString.indexOf("<test xmlns=\"http://foo\"") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testServerClientProxyWithWsdl2() throws Exception {
        final Latch latch = new Latch();
        ((FunctionalTestComponent)this.getComponent("serverClientProxyWithWsdl2")).setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch.countDown();
            }
        });
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyWithWsdl2", (Object)msg, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((resString.indexOf("<test xmlns=\"http://foo\"") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testServerClientProxyWithTransform() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyWithTransform", (Object)msg, null);
        String resString = result.getPayloadAsString();
        System.out.println(resString);
        Assert.assertTrue((resString.indexOf("<transformed xmlns=\"http://foo\">") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testProxyWithDatabinding() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><greetMe xmlns=\"http://apache.org/hello_world_soap_http/types\"><requestType>Dan</requestType></greetMe></soap:Body></soap:Envelope>";
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/greeter-databinding-proxy", (Object)msg, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("greetMeResponse") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testProxyWithFault() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><invalid xmlns=\"http://apache.org/hello_world_soap_http/types\"><requestType>Dan</requestType></invalid></soap:Body></soap:Envelope>";
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/greeter-proxy", (Object)msg, null);
        String resString = result.getPayloadAsString();
        Assert.assertFalse((String)"Status code should not be 'OK' when the proxied endpoint returns a fault", (boolean)String.valueOf(200).equals(result.getOutboundProperty("http.status")));
        Assert.assertTrue((resString.indexOf("Fault") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testProxyWithIntermediateTransform() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><greetMe xmlns=\"http://apache.org/hello_world_soap_http/types\"><requestType>Dan</requestType></greetMe></soap:Body></soap:Envelope>";
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/transform-proxy", (Object)msg, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("greetMeResponse") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testServerNoSoapAction() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        String path = "/services/routeBasedOnNoSoapAction";
        String expectedString = "<test xmlns=\"http://foo\"";
        MuleMessage result = this.executeSoapCall(msg, "", path);
        this.assertResultContains(result, expectedString);
        result = this.executeSoapCall(msg, null, path);
        this.assertResultContains(result, expectedString);
    }

    @Test
    public void testServerNoSoapActionSpoofing() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        MuleMessage result = this.executeSoapCall(msg, "echo", "/services/routeBasedOnNoSoapAction");
        this.assertResultIsFault(result);
    }

    @Test
    public void testServerSoapAction() throws Exception {
        String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        MuleMessage result = this.executeSoapCall(msg, "EchoOperation1", "/services/routeBasedOnSoapAction");
        this.assertResultContains(result, "<new:parameter1");
    }

    @Test
    public void testServerSoapActionSpoofing() throws Exception {
        String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        MuleMessage result = this.executeSoapCall(msg, "NonSpecifiedOperation", "/services/routeBasedOnSoapAction");
        this.assertResultIsFault(result);
    }

    @Test
    public void testServerNoSoapActionNoWsdl() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        String path = "/services/routeBasedOnNoSoapActionNoWsdl";
        String expectedString = "<test xmlns=\"http://foo\"";
        MuleMessage result = this.executeSoapCall(msg, "", path);
        this.assertResultContains(result, expectedString);
        result = this.executeSoapCall(msg, null, path);
        this.assertResultContains(result, expectedString);
        msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        result = this.executeSoapCall(msg, "", path);
        this.assertResultContains(result, "<new:parameter1");
        result = this.executeSoapCall(msg, null, path);
        this.assertResultContains(result, "<new:parameter1");
    }

    @Test
    public void testServerSoapActionNoWsdl() throws Exception {
        String path = "/services/routeBasedNoWsdl";
        this.msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        MuleMessage result = this.executeSoapCall(this.msg, "EchoOperation1", path);
        this.assertResultContains(result, "<new:parameter1");
    }

    private MuleMessage executeSoapCall(String msg, String soapAction, String path) throws MuleException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (soapAction != null) {
            props.put("SOAPAction", soapAction);
        }
        MuleClient client = new MuleClient(muleContext);
        return client.send("http://localhost:" + this.dynamicPort.getNumber() + path, (Object)msg, props);
    }

    private void assertResultContains(MuleMessage result, String expectedString) throws Exception {
        String resString = result.getPayloadAsString();
        System.out.println(resString);
        Assert.assertTrue((String)("message didn't contain the test string: " + expectedString + " but was: " + resString), (resString.indexOf(expectedString) != -1 ? 1 : 0) != 0);
    }

    private void assertResultIsFault(MuleMessage result) throws Exception {
        String resString = result.getPayloadAsString();
        Assert.assertFalse((String)"Status code should not be 'OK' when the proxied endpoint returns a fault", (boolean)String.valueOf(200).equals(result.getOutboundProperty("http.status")));
        Assert.assertTrue((resString.indexOf("Fault") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testOneWaySendWithSoapAction() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/onewayWithSoapAction", (Object)this.prepareOneWayTestMessage(), this.prepareOneWayWithSoapActionTestProperties());
        Assert.assertEquals((Object)"", (Object)result.getPayloadAsString());
        AsyncServiceWithSoapAction component = (AsyncServiceWithSoapAction)this.getComponent("asyncServiceWithSoapAction");
        Assert.assertTrue((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWayDispatchWithSoapAction() throws Exception {
        new MuleClient(muleContext).dispatch("http://localhost:" + this.dynamicPort.getNumber() + "/services/onewayWithSoapAction", (Object)this.prepareOneWayTestMessage(), this.prepareOneWayWithSoapActionTestProperties());
        AsyncServiceWithSoapAction component = (AsyncServiceWithSoapAction)this.getComponent("asyncServiceWithSoapAction");
        Assert.assertTrue((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWaySendWithSoapActionSpoofing() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/onewayWithSoapAction", (Object)this.prepareOneWayTestMessage(), this.prepareOneWaySpoofingTestProperties());
        Assert.assertNotNull((Object)result);
        AsyncServiceWithSoapAction component = (AsyncServiceWithSoapAction)this.getComponent("asyncServiceWithSoapAction");
        Assert.assertFalse((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWayDispatchWithSoapActionSpoofing() throws Exception {
        new MuleClient(muleContext).dispatch("http://localhost:" + this.dynamicPort.getNumber() + "/services/onewayWithSoapAction", (Object)this.prepareOneWayTestMessage(), this.prepareOneWaySpoofingTestProperties());
        AsyncServiceWithSoapAction component = (AsyncServiceWithSoapAction)this.getComponent("asyncServiceWithSoapAction");
        Assert.assertFalse((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWaySendUnknownSoapAction() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/oneway", (Object)this.prepareOneWayTestMessage(), this.prepareOneWayWithSoapActionTestProperties());
        Assert.assertNotNull((Object)result);
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertFalse((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWayDispatchUnknownSoapAction() throws Exception {
        new MuleClient(muleContext).dispatch("http://localhost:" + this.dynamicPort.getNumber() + "/services/oneway", (Object)this.prepareOneWayTestMessage(), this.prepareOneWayWithSoapActionTestProperties());
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertFalse((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWaySend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/oneway", (Object)this.prepareOneWayTestMessage(), this.prepareOneWayTestProperties());
        Assert.assertNotNull((Object)result);
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertTrue((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWayDispatch() throws Exception {
        new MuleClient(muleContext).dispatch("http://localhost:" + this.dynamicPort.getNumber() + "/services/oneway", (Object)this.prepareOneWayTestMessage(), this.prepareOneWayTestProperties());
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertTrue((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testProxyWithCommentInRequest() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/envelope-proxy", (Object)this.msgWithComment, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains(this.doGoogleSearch));
    }

    @Test
    public void testProxyEnvelopeWithXsltTransformation() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/envelope-xslt-proxy", (Object)this.msg, null);
        Assert.assertTrue((boolean)result.getPayloadAsString().contains(this.msg));
    }

    @Test
    public void testProxyCDATA() throws Exception {
        String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sup=\"http://support.cxf.module.mule.org/\">\n<soapenv:Header/>\n<soapenv:Body>\n<sup:invoke>\n<soapenv:Envelope>\n<soapenv:Header/>\n<soapenv:Body>\n<sup:invoke>\n<Request>\n<servicePayload><![CDATA[<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><soapenv:Header/><soapenv:Body><int:test/></soapenv:Body></soapenv:Envelope>]]></servicePayload>\n</Request>\n</sup:invoke>\n</soapenv:Body>\n</soapenv:Envelope>\n</sup:invoke>\n</soapenv:Body>\n</soapenv:Envelope>";
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/CDATAService", (Object)msg, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getPayloadAsString().contains("![CDATA["));
    }

    @Test
    public void testProxyWithSoapFault() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        String proxyFaultMsg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><greetMe xmlns=\"http://apache.org/hello_world_fault/types\"><requestType>Dan</requestType></greetMe></soap:Body></soap:Envelope>";
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/proxyFault", (Object)proxyFaultMsg, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains("ERROR"));
    }

    protected String prepareOneWayTestMessage() {
        return "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns:send xmlns:ns=\"http://testmodels.cxf.module.mule.org/\"><text>hello</text></ns:send></soap:Body></soap:Envelope>";
    }

    protected Map<String, Object> prepareOneWayTestProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SOAPAction", "");
        return props;
    }

    protected Map<String, Object> prepareOneWayWithSoapActionTestProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SOAPAction", "send");
        return props;
    }

    protected Map<String, Object> prepareOneWaySpoofingTestProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SOAPAction", "hiddenAction");
        return props;
    }
}

