/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.config;

import java.util.Map;
import org.apache.ws.security.validate.NoOpValidator;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.cxf.config.WsSecurity;
import org.mule.module.cxf.wssec.ClientPasswordCallback;
import org.mule.tck.junit4.FunctionalTestCase;

public class WsSecurityDefinitionParserTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "ws-security-config.xml";
    }

    @Test
    public void testWsSecurityConfig() {
        WsSecurity wsSecurity = (WsSecurity)muleContext.getRegistry().lookupObject("config1");
        Assert.assertNotNull((Object)wsSecurity);
        Assert.assertNotNull((Object)wsSecurity.getSecurityManager());
        Assert.assertNotNull((Object)wsSecurity.getConfigProperties());
        Assert.assertFalse((boolean)wsSecurity.getConfigProperties().isEmpty());
        Map wsProperties = wsSecurity.getConfigProperties();
        Assert.assertEquals((Object)"UsernameToken", wsProperties.get("action"));
        Assert.assertEquals((Object)"joe", wsProperties.get("user"));
        Assert.assertEquals((Object)"PasswordText", wsProperties.get("passwordType"));
        Assert.assertEquals((Object)"org.mule.module.cxf.wssec.ClientPasswordCallback", wsProperties.get("passwordCallbackClass"));
        Assert.assertNotNull((Object)wsSecurity.getCustomValidator());
        Assert.assertFalse((boolean)wsSecurity.getCustomValidator().isEmpty());
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.ut.validator") instanceof NoOpValidator));
    }

    @Test
    public void testWsSecurityConfig2() {
        WsSecurity wsSecurity = (WsSecurity)muleContext.getRegistry().lookupObject("config2");
        Assert.assertNotNull((Object)wsSecurity);
        Assert.assertNotNull((Object)wsSecurity.getConfigProperties());
        Assert.assertFalse((boolean)wsSecurity.getConfigProperties().isEmpty());
        Map wsProperties = wsSecurity.getConfigProperties();
        Assert.assertEquals((Object)"Timestamp Signature Encrypt", wsProperties.get("action"));
        Assert.assertEquals((Object)"joe", wsProperties.get("user"));
        Assert.assertEquals((Object)"org/mule/module/cxf/wssec/wssecurity.properties", wsProperties.get("signaturePropFile"));
        Assert.assertEquals((Object)"org/mule/module/cxf/wssec/wssecurity.properties", wsProperties.get("encryptionPropFile"));
        Assert.assertTrue((boolean)(wsProperties.get("passwordCallbackRef") instanceof ClientPasswordCallback));
    }

    @Test
    public void testWsSecurityConfigCustomTimestampValidator() {
        WsSecurity wsSecurity = (WsSecurity)muleContext.getRegistry().lookupObject("customTimestampConfig");
        Assert.assertNotNull((Object)wsSecurity);
        Assert.assertNotNull((Object)wsSecurity.getCustomValidator());
        Assert.assertFalse((boolean)wsSecurity.getCustomValidator().isEmpty());
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.timestamp.validator") instanceof NoOpValidator));
    }

    @Test
    public void testWsSecurityConfigCustomSAML1Validator() {
        WsSecurity wsSecurity = (WsSecurity)muleContext.getRegistry().lookupObject("customSAML1Config");
        Assert.assertNotNull((Object)wsSecurity);
        Assert.assertNotNull((Object)wsSecurity.getCustomValidator());
        Assert.assertFalse((boolean)wsSecurity.getCustomValidator().isEmpty());
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.saml1.validator") instanceof NoOpValidator));
    }

    @Test
    public void testWsSecurityConfigCustomSAML2Validator() {
        WsSecurity wsSecurity = (WsSecurity)muleContext.getRegistry().lookupObject("customSAML2Config");
        Assert.assertNotNull((Object)wsSecurity);
        Assert.assertNotNull((Object)wsSecurity.getCustomValidator());
        Assert.assertFalse((boolean)wsSecurity.getCustomValidator().isEmpty());
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.saml2.validator") instanceof NoOpValidator));
    }

    @Test
    public void testWsSecurityConfigCustomSignatureValidator() {
        WsSecurity wsSecurity = (WsSecurity)muleContext.getRegistry().lookupObject("customSignatureConfig");
        Assert.assertNotNull((Object)wsSecurity);
        Assert.assertNotNull((Object)wsSecurity.getCustomValidator());
        Assert.assertFalse((boolean)wsSecurity.getCustomValidator().isEmpty());
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.signature.validator") instanceof NoOpValidator));
    }

    @Test
    public void testWsSecurityConfigCustomBSTValidator() {
        WsSecurity wsSecurity = (WsSecurity)muleContext.getRegistry().lookupObject("customBSTConfig");
        Assert.assertNotNull((Object)wsSecurity);
        Assert.assertNotNull((Object)wsSecurity.getCustomValidator());
        Assert.assertFalse((boolean)wsSecurity.getCustomValidator().isEmpty());
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.bst.validator") instanceof NoOpValidator));
    }

    @Test
    public void testWsSecurityConfigCustomMultipleValidator() {
        WsSecurity wsSecurity = (WsSecurity)muleContext.getRegistry().lookupObject("customMultipleConfig");
        Assert.assertNotNull((Object)wsSecurity);
        Assert.assertNotNull((Object)wsSecurity.getCustomValidator());
        Assert.assertFalse((boolean)wsSecurity.getCustomValidator().isEmpty());
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.ut.validator") instanceof NoOpValidator));
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.saml1.validator") instanceof NoOpValidator));
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.saml2.validator") instanceof NoOpValidator));
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.timestamp.validator") instanceof NoOpValidator));
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.signature.validator") instanceof NoOpValidator));
        Assert.assertTrue((boolean)(wsSecurity.getCustomValidator().get("ws-security.bst.validator") instanceof NoOpValidator));
    }
}

