/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.issues;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class LargeProxyTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    protected String getConfigResources() {
        return "largeproxytest-config.xml";
    }

    @Test
    public void testLargeMessageWithEchoProxy() throws Exception {
        int length = 5000;
        final MuleClient client = new MuleClient(muleContext);
        StringBuffer b = new StringBuffer();
        int counter = 1;
        while (b.length() < length) {
            b.append(counter).append(" ");
            ++counter;
        }
        final String largeString = b.toString().trim();
        final String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><echo xmlns=\"http://simple.component.mule.org/\"><echo>" + largeString + "</echo>" + "</echo>" + "</soap:Body>" + "</soap:Envelope>";
        final CountDownLatch latch = new CountDownLatch(100);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    try {
                        MuleMessage result = client.send("http://localhost:" + LargeProxyTestCase.this.dynamicPort1.getNumber() + "/services/EchoProxy", (Object)msg, null);
                        String payloadAsStr = result.getPayloadAsString();
                        Assert.assertTrue((String)"The payload length should never be 0", (payloadAsStr.length() != 0 ? 1 : 0) != 0);
                        Assert.assertTrue((payloadAsStr.indexOf(largeString) != -1 ? 1 : 0) != 0);
                        latch.countDown();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        for (int j = 0; j < 5; ++j) {
            new Thread(runnable).start();
        }
        latch.await(50000L, TimeUnit.SECONDS);
    }
}

