/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.wssec;

import java.util.Map;
import javax.xml.ws.soap.SOAPFaultException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.module.cxf.wssec.ClientPasswordCallback;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class WsSecurityConfigMelExpressionTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "org/mule/module/cxf/wssec/ws-security-config-mel-expression-config.xml";
    }

    @Test
    public void testSuccessfulAuthentication() throws Exception {
        ClientPasswordCallback.setPassword("secret");
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"PasswordText", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://greetMe", (MuleMessage)request);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"Hello PasswordText", (Object)received.getPayloadAsString());
    }

    @Test
    public void testFailAuthentication() throws Exception {
        ClientPasswordCallback.setPassword("secret");
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"UnknownPasswordEncoding", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://greetMe", (MuleMessage)request);
        Assert.assertNotNull((Object)received);
        Assert.assertNotNull((Object)received.getExceptionPayload());
        Assert.assertTrue((boolean)(received.getExceptionPayload().getException().getCause() instanceof SOAPFaultException));
        Assert.assertTrue((boolean)((SOAPFaultException)received.getExceptionPayload().getException().getCause()).getMessage().contains("Security processing failed"));
    }
}

