/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class CxfCustomHttpHeaderTestCase
extends AbstractServiceAndFlowTestCase
implements EndpointMessageNotificationListener {
    protected String endpointAddress = null;
    private List<MuleMessage> notificationMsgList = new ArrayList<MuleMessage>();
    private CountDownLatch latch = null;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public CxfCustomHttpHeaderTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "headers-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "headers-conf-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        this.latch = new CountDownLatch(2);
        muleContext.registerListener((ServerNotificationListener)this);
        MuleClient client = new MuleClient(muleContext);
        this.endpointAddress = ((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("cxfInbound")).getAddress() + "?method=onReceive";
    }

    protected void doTearDown() throws Exception {
        muleContext.unregisterListener((ServerNotificationListener)this);
    }

    @Test
    public void testCxf() throws Exception {
        Object[] payload = new Object[]{"Test String"};
        String myProperty = "myProperty";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_USER", "alan");
        props.put("method", "onReceive");
        props.put(myProperty, myProperty);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage reply = client.send("cxf:" + this.endpointAddress, (Object)payload, props);
        Assert.assertNotNull((Object)reply);
        Assert.assertNotNull((Object)reply.getPayload());
        Assert.assertEquals((Object)"Test String Received", (Object)reply.getPayloadAsString());
        Thread.sleep(3000L);
        Assert.assertEquals((long)2L, (long)this.notificationMsgList.size());
        Assert.assertEquals((Object)"alan", (Object)this.notificationMsgList.get(0).getOutboundProperty("MULE_USER"));
        Assert.assertNull((Object)this.notificationMsgList.get(0).getOutboundProperty("MULE_IGNORE_METHOD"));
        Assert.assertEquals((Object)myProperty, (Object)this.notificationMsgList.get(0).getOutboundProperty(myProperty));
    }

    public void onNotification(ServerNotification notification) {
        if (notification instanceof EndpointMessageNotification) {
            String uri = ((EndpointMessageNotification)notification).getEndpoint();
            if (this.endpointAddress.equals(uri)) {
                this.notificationMsgList.add((MuleMessage)notification.getSource());
                this.latch.countDown();
            }
        } else {
            Assert.fail((String)("invalid notification: " + notification));
        }
    }
}

