/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.cxf.interceptor.Fault;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.AbstractTransformer;

public class CxfErrorBehaviorTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String requestFaultPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0></arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    private static final String requestPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>hi</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public CxfErrorBehaviorTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "cxf-error-behavior-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "cxf-error-behavior-flow.xml"});
    }

    @Test
    public void testFaultInCxfService() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestFaultPayload, (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testServiceWithFault", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<faultstring>"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)response.getInboundProperty("http.status"));
    }

    @Test
    public void testFaultInCxfSimpleService() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testSimpleServiceWithFault", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<faultstring>"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)response.getInboundProperty("http.status"));
    }

    @Test
    public void testExceptionThrownInTransformer() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testTransformerException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<faultstring>"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)response.getInboundProperty("http.status"));
    }

    @Test
    public void testUnwrapException() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testUnwrapException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("Illegal argument!!"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)response.getInboundProperty("http.status"));
    }

    @Test
    public void testClientWithSOAPFault() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("vm://testClientSOAPFault", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getExceptionPayload());
        Assert.assertTrue((boolean)(response.getExceptionPayload().getException().getCause() instanceof Fault));
        Assert.assertNull((Object)response.getInboundProperty("http.status"));
    }

    @Test
    public void testClientWithTransformerException() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("vm://testClientTransformerException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getExceptionPayload());
        Assert.assertTrue((boolean)(response.getExceptionPayload().getException() instanceof MessagingException));
    }

    @Test
    public void testServerClientProxyWithFault() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testProxyWithFault", (Object)requestFaultPayload, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains("<faultstring>Cxf Exception Message</faultstring>"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)result.getInboundProperty("http.status"));
    }

    @Test
    public void testServerClientProxyWithTransformerException() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testProxyWithTransformerException", (Object)requestPayload, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains("TransformerException"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)result.getInboundProperty("http.status"));
    }

    @Test
    public void testServerClientJaxwsWithUnwrapFault() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testUnwrapProxyFault", (Object)requestPayload, null);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains("Illegal argument!!"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)result.getInboundProperty("http.status"));
    }

    public static class CxfTransformerThrowsExceptions
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            throw new TransformerException(CoreMessages.failedToBuildMessage());
        }
    }
}

