/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class Http10TestCase
extends AbstractServiceAndFlowTestCase {
    @ClassRule
    public static DynamicPort dynamicPort = new DynamicPort("port1");

    public Http10TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-10-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-10-conf-flow.xml"});
    }

    @Test
    public void testHttp10TransformerNotOnProtocol() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap props = new HashMap();
        MuleMessage result = client.send("cxfOutbound", (Object)"Dan", props);
        Assert.assertEquals((Object)"Hello Dan", (Object)result.getPayload());
        result = client.request("vm://out", 1000L);
        Assert.assertFalse((boolean)"chunked".equals(result.getOutboundProperty("Transfer-Encoding")));
    }

    @Test
    public void testHttp10TransformerOnProtocol() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap props = new HashMap();
        MuleMessage result = client.send("cxfOutbound2", (Object)"Dan", props);
        Assert.assertEquals((Object)"Hello Dan", (Object)result.getPayload());
        result = client.request("vm://out", 1000L);
        Assert.assertFalse((boolean)"chunked".equals(result.getOutboundProperty("Transfer-Encoding")));
    }
}

