/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.mime.TestMtom;
import org.apache.cxf.mime.TestMtomService;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class MtomTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public MtomTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "mtom-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mtom-conf-flow.xml"});
    }

    @Test
    public void testEchoService() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/mtom_xop.wsdl");
        Assert.assertNotNull((Object)wsdl);
        CxfConfiguration clientConfig = new CxfConfiguration();
        clientConfig.setMuleContext(muleContext);
        clientConfig.initialise();
        BusFactory.setThreadDefaultBus((Bus)clientConfig.getCxfBus());
        TestMtomService svc = new TestMtomService(wsdl);
        TestMtom port = svc.getTestMtomPort();
        BindingProvider bp = (BindingProvider)port;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:" + this.dynamicPort.getNumber() + "/services/mtom");
        ((SOAPBinding)bp.getBinding()).setMTOMEnabled(true);
        File file = new File("src/test/resources/mtom-conf-service.xml");
        DataHandler dh = new DataHandler((DataSource)new FileDataSource(file));
        Holder name = new Holder((Object)"test");
        Holder info = new Holder((Object)dh);
        port.testXop(name, info);
        Assert.assertEquals((Object)"return detail + test", (Object)name.value);
        Assert.assertNotNull((Object)info.value);
        InputStream input = ((DataHandler)info.value).getInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)bos);
        input.close();
    }
}

