/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ProxyPortMatchingSoapVersionTest
extends FunctionalTestCase {
    private static final String SOAP_REQUEST_PATTERN = "<soap:Envelope xmlns:soap=\"%s\" xmlns:web=\"http://www.webserviceX.NET/\">\n   <soap:Header/>\n   <soap:Body>\n      <web:GetQuote><web:symbol>TEST</web:symbol></web:GetQuote>\n   </soap:Body>\n</soap:Envelope>";
    private static final String SOAP_11_SCHEMA = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP_12_SCHEMA = "http://www.w3.org/2003/05/soap-envelope";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");

    protected String getConfigResources() {
        return "proxy-port-matching-soap-version-config.xml";
    }

    @Test
    public void proxyServiceMultiplePortsSoapVersion11() throws Exception {
        this.assertValidRequest("proxy11_multiplePorts", this.getRequest(SOAP_11_SCHEMA));
        this.assertInvalidRequest("proxy11_multiplePorts", this.getRequest(SOAP_12_SCHEMA));
    }

    @Test
    public void proxyServiceMultiplePortsSoapVersion12() throws Exception {
        this.assertValidRequest("proxy12_multiplePorts", this.getRequest(SOAP_12_SCHEMA));
    }

    @Test
    public void proxyServiceSinglePortSoapVersion12() throws Exception {
        this.assertValidRequest("proxy12_singlePort", this.getRequest(SOAP_11_SCHEMA));
        this.assertInvalidRequest("proxy12_singlePort", this.getRequest(SOAP_12_SCHEMA));
    }

    private void assertValidRequest(String flowName, String request) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent result = flow.process(ProxyPortMatchingSoapVersionTest.getTestEvent((Object)request));
        Assert.assertEquals((Object)request, (Object)result.getMessage().getPayloadAsString());
    }

    private void assertInvalidRequest(String flowName, String request) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent result = flow.process(ProxyPortMatchingSoapVersionTest.getTestEvent((Object)request));
        Assert.assertTrue((boolean)result.getMessage().getPayloadAsString().contains("VersionMismatch"));
    }

    private String getRequest(String schema) {
        return String.format(SOAP_REQUEST_PATTERN, schema);
    }
}

