/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ProxyValidationComparisonTestCase
extends FunctionalTestCase {
    private static final String ONE_LINER_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><echo xmlns=\"http://www.muleumo.org\"><echo>hey, there!</echo></echo></soap:Body></soap:Envelope>";
    @Rule
    public final DynamicPort httpPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "proxy-validation-comparison-config.xml";
    }

    @Test
    public void responsesAreEqualWithAndWithoutValidationEnvelope() throws Exception {
        this.testResponsesWithPayload("envelope");
    }

    @Test
    public void responsesAreEqualWithAndWithoutValidationBody() throws Exception {
        this.testResponsesWithPayload("body");
    }

    private void testResponsesWithPayload(String payload) throws Exception {
        MuleMessage responseWithValidation = this.getResponseFor(payload + "Validation");
        MuleMessage responseWithNoValidation = this.getResponseFor(payload + "NoValidation");
        XMLAssert.assertXMLEqual((String)responseWithValidation.getPayloadAsString(), (String)responseWithNoValidation.getPayloadAsString());
    }

    private MuleMessage getResponseFor(String path) throws MuleException {
        return muleContext.getClient().send(String.format("http://localhost:%s/services/%s", this.httpPort.getNumber(), path), (Object)ONE_LINER_REQUEST, null);
    }
}

