/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class WebServiceWrapperWithCxfTestCase
extends AbstractServiceAndFlowTestCase {
    private String testString = "test";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public WebServiceWrapperWithCxfTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "mule-ws-wrapper-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mule-ws-wrapper-config-flow.xml"});
    }

    @Test
    public void testWsCall() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("vm://testin", (MuleMessage)new DefaultMuleMessage((Object)this.testString, muleContext));
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((String)"Payload", (Object)this.testString, (Object)result.getPayloadAsString());
    }

    @Test
    public void testWsCallWithUrlFromMessage() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        Properties props = new Properties();
        props.setProperty("ws.service.url", "http://localhost:" + this.dynamicPort.getNumber() + "/services/TestUMO?method=onReceive");
        MuleMessage result = client.send("vm://testin2", (Object)this.testString, (Map)props);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((String)"Payload", (Object)this.testString, (Object)result.getPayloadAsString());
    }
}

