/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.jaxws;

import java.util.HashMap;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.module.cxf.jaxws.GreeterNotNull;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;

public class ClientTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    private Prober prober = new PollingProber(5000L, 100L);

    protected String getConfigResources() {
        return "jaxws-client-conf.xml";
    }

    @Test
    public void testGeneratedClientWithQuartz() throws Exception {
        GreeterImpl impl = this.getGreeter();
        this.prober.check((Probe)new GreeterNotNull(impl));
        Assert.assertEquals((long)1L, (long)impl.getInvocationCount());
    }

    @Test
    public void testClientWithMuleClient() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("operation", "greetMe");
        MuleMessage result = client.send("clientEndpoint", (Object)"Dan", props);
        Assert.assertEquals((Object)"Hello Dan", (Object)result.getPayload());
        GreeterImpl impl = this.getGreeter();
        this.prober.check((Probe)new GreeterNotNull(impl));
        Assert.assertEquals((long)2L, (long)impl.getInvocationCount());
    }

    private GreeterImpl getGreeter() throws Exception {
        Object instance = this.getComponent("greeterService");
        return (GreeterImpl)instance;
    }
}

