/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.wssec;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class SAMLValidatorTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "org/mule/module/cxf/wssec/saml-validator-conf.xml";
    }

    @Test
    public void testSAMLUnsignedAssertion() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"me", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://greetMe", (MuleMessage)request);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"Hello me", (Object)received.getPayloadAsString());
    }

    @Test
    public void testSAMLSignedAssertion() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"me", (Map)null, muleContext);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage received = client.send("vm://greetMeSigned", (MuleMessage)request);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"Hello me", (Object)received.getPayloadAsString());
    }

    public static class PasswordCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[0];
            pc.setPassword("secret");
        }
    }
}

