/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class ProxyValidationComparisonTestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    private static final String ONE_LINER_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><echo xmlns=\"http://www.muleumo.org\"><echo>hey, there!</echo></echo></soap:Body></soap:Envelope>";
    @Rule
    public final DynamicPort httpPort = new DynamicPort("port1");
    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"proxy-validation-comparison-config.xml"}, {"proxy-validation-comparison-config-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void responsesAreEqualWithAndWithoutValidationEnvelope() throws Exception {
        this.testResponsesWithPayload("envelope");
    }

    @Test
    public void responsesAreEqualWithAndWithoutValidationBody() throws Exception {
        this.testResponsesWithPayload("body");
    }

    private void testResponsesWithPayload(String payload) throws Exception {
        MuleMessage responseWithValidation = this.getResponseFor(payload + "Validation");
        MuleMessage responseWithNoValidation = this.getResponseFor(payload + "NoValidation");
        XMLAssert.assertXMLEqual((String)responseWithValidation.getPayloadAsString(), (String)responseWithNoValidation.getPayloadAsString());
    }

    private MuleMessage getResponseFor(String path) throws MuleException {
        return muleContext.getClient().send(String.format("http://localhost:%s/services/%s", this.httpPort.getNumber(), path), this.getTestMuleMessage(ONE_LINER_REQUEST), (OperationOptions)HTTP_REQUEST_OPTIONS);
    }
}

