/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class WebServiceWrapperWithCxfTestCase
extends AbstractServiceAndFlowTestCase {
    private String testString = "test";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public WebServiceWrapperWithCxfTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "mule-ws-wrapper-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mule-ws-wrapper-config-flow.xml"});
    }

    @Test
    public void testWsCall() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://testin", this.getTestMuleMessage(this.testString));
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((String)"Payload", (Object)this.testString, (Object)result.getPayloadAsString());
    }

    @Test
    public void testWsCallWithUrlFromMessage() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("ws.service.url", "http://localhost:" + this.dynamicPort.getNumber() + "/services/TestUMO?method=onReceive");
        MuleMessage result = client.send("vm://testin2", (Object)this.testString, props);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((String)"Payload", (Object)this.testString, (Object)result.getPayloadAsString());
    }
}

