/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.issues;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.cxf.wssec.ClientPasswordCallback;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class ProxyServiceDecryptedNotAvailableAsPayload
extends FunctionalTestCase {
    @ClassRule
    public static SystemProperty disablePropertiesMapping = new SystemProperty("com.sun.net.ssl.checkRevocation", "false");
    private static final String SOAP_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><test xmlns=\"http://foo\"> foo </test></soap:Body></soap:Envelope>";
    private static final String SOAP_RESPONSE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><test xmlns=\"http://foo\"> foo </test>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();

    @Before
    public void doSetUp() throws Exception {
        ClientPasswordCallback.setPassword("secret");
    }

    @Test
    public void testDecryptedPayloadAvailable() throws Exception {
        MuleMessage msg = this.getTestMuleMessage(SOAP_REQUEST);
        MuleMessage muleMessage = muleContext.getClient().send("http://localhost:" + this.dynamicPort.getNumber() + "/client", msg, (OperationOptions)HTTP_REQUEST_OPTIONS);
        MatcherAssert.assertThat((Object)muleMessage.getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)SOAP_RESPONSE));
    }

    protected String getConfigFile() {
        return "issues/proxy-service-serving-wsdl-decrypted-no-available.xml";
    }
}

