/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import javax.xml.ws.Holder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.transformer.TransformerException;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.SensingNullRequestResponseMessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.AbstractTransformer;

public class HolderNonBlockingTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "holder-conf-httpn-nb.xml";
    }

    @Test
    public void testClientEchoHolder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/echoClient", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])HolderNonBlockingTestCase.deserializeResponse(received);
        Assert.assertEquals((Object)"one-response", (Object)payload[0]);
        Assert.assertEquals(null, (Object)payload[1]);
        Assert.assertEquals((Object)"one-holder1", (Object)((Holder)payload[2]).value);
        Assert.assertEquals((Object)"one-holder2", (Object)((Holder)payload[3]).value);
        this.getSensingInstance("sensingRequestResponseProcessorEcho").assertRequestResponseThreadsDifferent();
    }

    @Test
    public void testClientProxyEchoHolder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/echoClientProxy", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])HolderNonBlockingTestCase.deserializeResponse(received);
        Assert.assertEquals((Object)"one-response", (Object)payload[0]);
        Assert.assertEquals((Object)"one-holder1", (Object)((Holder)payload[1]).value);
        Assert.assertEquals((Object)"one-holder2", (Object)((Holder)payload[2]).value);
        this.getSensingInstance("sensingRequestResponseProcessorEchoProxy").assertRequestResponseThreadsSame();
    }

    @Test
    public void testClientEcho2Holder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/echo2Client", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])HolderNonBlockingTestCase.deserializeResponse(received);
        Assert.assertEquals((Object)"one-response", (Object)payload[0]);
        Assert.assertEquals(null, (Object)payload[1]);
        Assert.assertEquals((Object)"two-holder", (Object)((Holder)payload[2]).value);
        this.getSensingInstance("sensingRequestResponseProcessorEcho2").assertRequestResponseThreadsDifferent();
    }

    @Test
    public void testClientProxyEcho2Holder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/echo2ClientProxy", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])HolderNonBlockingTestCase.deserializeResponse(received);
        Assert.assertEquals((Object)"one-response", (Object)payload[0]);
        Assert.assertEquals((Object)"two-holder", (Object)((Holder)payload[1]).value);
        this.getSensingInstance("sensingRequestResponseProcessorEchoProxy2").assertRequestResponseThreadsSame();
    }

    @Test
    public void testClientEcho3Holder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/echo3Client", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])HolderNonBlockingTestCase.deserializeResponse(received);
        Assert.assertEquals(null, (Object)payload[0]);
        Assert.assertEquals((Object)"one", (Object)((Holder)payload[1]).value);
        this.getSensingInstance("sensingRequestResponseProcessorEcho3").assertRequestResponseThreadsDifferent();
    }

    @Test
    public void testClientProxyEcho3Holder() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"TEST", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/echo3ClientProxy", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertNotNull((Object)received);
        Object[] payload = (Object[])HolderNonBlockingTestCase.deserializeResponse(received);
        Assert.assertEquals(null, (Object)payload[0]);
        Assert.assertEquals((Object)"one", (Object)((Holder)payload[1]).value);
        this.getSensingInstance("sensingRequestResponseProcessorEchoProxy3").assertRequestResponseThreadsSame();
    }

    private SensingNullRequestResponseMessageProcessor getSensingInstance(String instanceBeanName) {
        return (SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(instanceBeanName);
    }

    private static <T> T deserializeResponse(MuleMessage received) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)received.getPayload());
        Object objectPayload = objectInputStream.readObject();
        return (T)objectPayload;
    }

    public static class HolderTransformer3
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            Holder outS1 = new Holder();
            Object[] objArray = new Object[]{outS1, "one"};
            return objArray;
        }
    }

    public static class HolderTransformer2
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            Holder outS1 = new Holder();
            Object[] objArray = new Object[]{"one", outS1, "two"};
            return objArray;
        }
    }

    public static class HolderTransformer
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            Holder outS1 = new Holder();
            Holder outS2 = new Holder();
            Object[] objArray = new Object[]{"one", outS1, outS2};
            return objArray;
        }
    }
}

