/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.module.cxf.testmodels.AsyncService;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;

public class OneWayOutboundTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    protected String getConfigFile() {
        return "one-way-outbound-config.xml";
    }

    @Test
    public void jaxwsClientSupportsOneWayCall() throws Exception {
        MuleEvent event = this.runFlow("jaxwsClient", OneWayOutboundTestCase.getTestEvent((Object)"Test Message"));
        this.assertOneWayResponse(event);
    }

    @Test
    public void proxyClientSupportsOneWayCall() throws Exception {
        String message = "<ns:send xmlns:ns=\"http://testmodels.cxf.module.mule.org/\"><text>hello</text></ns:send>";
        MuleEvent event = this.runFlow("proxyClient", OneWayOutboundTestCase.getTestEvent((Object)message));
        this.assertOneWayResponse(event);
    }

    private void assertOneWayResponse(MuleEvent event) throws Exception {
        Assert.assertThat((Object)((NullPayload)event.getMessage().getPayload()), (Matcher)CoreMatchers.is((Object)NullPayload.getInstance()));
        Assert.assertThat((Object)event.getMessage().getInboundProperty("http.status"), (Matcher)CoreMatchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertTrue((boolean)component.getLatch().await(5000L, TimeUnit.MILLISECONDS));
    }
}

