/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.Servlet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.transport.servlet.jetty.util.EmbeddedJettyServer;

public class WsdlCallTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public final DynamicPort jettyPort = new DynamicPort("jettyPort");
    @Rule
    public final DynamicPort httpPort = new DynamicPort("httpPort");
    private EmbeddedJettyServer httpServer;

    public WsdlCallTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "wsdl-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "wsdl-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "wsdl-conf-flow-httpn.xml"});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.httpServer = new EmbeddedJettyServer(this.jettyPort.getNumber(), "/", "/services/*", (Servlet)new MuleReceiverServlet(), muleContext);
        this.httpServer.start();
    }

    protected void doTearDown() throws Exception {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.stop();
        }
        super.doTearDown();
    }

    @Test
    public void testRequestWsdlWithServlets() throws Exception {
        InputStream wsdlStream = new URL("http://localhost:" + this.jettyPort.getNumber() + "/services/mycomponent?wsdl").openStream();
        String location = "http://localhost:" + this.jettyPort.getNumber() + "/services/mycomponent";
        Document document = new SAXReader().read(wsdlStream);
        List nodes = document.selectNodes("//wsdl:definitions/wsdl:service");
        Assert.assertEquals((Object)"Callable", (Object)((Element)nodes.get(0)).attribute("name").getStringValue());
        nodes = document.selectNodes("//wsdl:definitions/wsdl:service/wsdl:port/soap:address");
        Assert.assertEquals((Object)location, (Object)((Element)nodes.get(0)).attribute("location").getStringValue());
    }

    @Test
    public void testRequestWsdlWithHttp() throws Exception {
        String location = "http://localhost:" + this.httpPort.getNumber() + "/cxfService";
        InputStream wsdlStream = new URL(location + "?wsdl").openStream();
        Document document = new SAXReader().read(wsdlStream);
        List nodes = document.selectNodes("//wsdl:definitions/wsdl:service");
        Assert.assertEquals((Object)((Element)nodes.get(0)).attribute("name").getStringValue(), (Object)"Callable");
        nodes = document.selectNodes("//wsdl:definitions/wsdl:service/wsdl:port/soap:address");
        Assert.assertEquals((Object)location, (Object)((Element)nodes.get(0)).attribute("location").getStringValue());
    }
}

