/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.validate.NoOpValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.module.cxf.CxfInboundMessageProcessor;
import org.mule.module.cxf.builder.WebServiceMessageProcessorBuilder;
import org.mule.module.cxf.config.WsConfig;
import org.mule.module.cxf.config.WsSecurity;
import org.mule.module.cxf.support.MuleSecurityManagerValidator;
import org.mule.module.cxf.testmodels.Echo;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class WebServiceMessageProcessorBuilderTestCase
extends AbstractMuleContextTestCase {
    private WebServiceMessageProcessorBuilder serviceMessageProcessorBuilder;
    private static final String SERVICE_NAME = "Echo";
    private static final String NAMESPACE = "http://cxf.apache.org/";

    @Before
    public void setUp() {
        this.serviceMessageProcessorBuilder = new WebServiceMessageProcessorBuilder();
    }

    @Test
    public void testBuildServiceAttribute() throws MuleException {
        this.serviceMessageProcessorBuilder.setService(SERVICE_NAME);
        this.serviceMessageProcessorBuilder.setNamespace(NAMESPACE);
        this.serviceMessageProcessorBuilder.setMuleContext(muleContext);
        this.serviceMessageProcessorBuilder.setServiceClass(Echo.class);
        CxfInboundMessageProcessor messageProcessor = this.serviceMessageProcessorBuilder.build();
        Assert.assertNotNull((Object)messageProcessor);
        QName serviceName = messageProcessor.getServer().getEndpoint().getService().getName();
        Assert.assertEquals((Object)new QName(NAMESPACE, SERVICE_NAME), (Object)serviceName);
    }

    @Test
    public void testWsSecurityConfig() throws MuleException {
        WsSecurity wsSecurity = new WsSecurity();
        this.addConfigProperties(wsSecurity);
        this.addSecurityManager(wsSecurity);
        this.addCustomValidator(wsSecurity);
        this.serviceMessageProcessorBuilder.setWsSecurity(wsSecurity);
        this.serviceMessageProcessorBuilder.setService(SERVICE_NAME);
        this.serviceMessageProcessorBuilder.setNamespace(NAMESPACE);
        this.serviceMessageProcessorBuilder.setMuleContext(muleContext);
        this.serviceMessageProcessorBuilder.setServiceClass(Echo.class);
        CxfInboundMessageProcessor messageProcessor = this.serviceMessageProcessorBuilder.build();
        Assert.assertNotNull((Object)messageProcessor);
        WSS4JInInterceptor wss4JInInterceptor = this.getInterceptor(messageProcessor.getServer().getEndpoint().getInInterceptors());
        Assert.assertNotNull((Object)wss4JInInterceptor);
        Map wss4jProperties = wss4JInInterceptor.getProperties();
        Assert.assertFalse((boolean)wss4jProperties.isEmpty());
        Assert.assertEquals((Object)"UsernameToken", wss4jProperties.get("action"));
        Map properties = this.serviceMessageProcessorBuilder.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertTrue((boolean)(properties.get("ws-security.ut.validator") instanceof MuleSecurityManagerValidator));
        Assert.assertTrue((boolean)(properties.get("ws-security.timestamp.validator") instanceof NoOpValidator));
    }

    private WSS4JInInterceptor getInterceptor(List<Interceptor<? extends Message>> interceptors) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!(interceptor instanceof WSS4JInInterceptor)) continue;
            return (WSS4JInInterceptor)interceptor;
        }
        return null;
    }

    private void addConfigProperties(WsSecurity wsSecurity) {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        configProperties.put("action", "UsernameToken");
        wsSecurity.setWsConfig(new WsConfig(configProperties));
    }

    private void addSecurityManager(WsSecurity wsSecurity) {
        wsSecurity.setSecurityManager(new MuleSecurityManagerValidator());
    }

    private void addCustomValidator(WsSecurity wsSecurity) {
        HashMap<String, NoOpValidator> customValidator = new HashMap<String, NoOpValidator>();
        customValidator.put("ws-security.timestamp.validator", new NoOpValidator());
        wsSecurity.setCustomValidator(customValidator);
    }
}

