/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.functional;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import javax.activation.DataHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;

@RunWith(value=Parameterized.class)
public class CxfJaxWsServiceAndClientTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Parameterized.Parameter(value=0)
    public String config;
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
    private static final String REQUEST_PAYLOAD = "<soap:Envelope \n           xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:svc=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<svc:sayHi>\n    <arg0>Test Message</arg0>\n</svc:sayHi>\n</soap:Body>\n</soap:Envelope>";
    private static final String RESPONSE_PAYLOAD = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:sayHiResponse xmlns:ns2=\"http://example.cxf.module.mule.org/\"><return>Hello\u2297 Test Message</return></ns2:sayHiResponse></soap:Body></soap:Envelope>";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"cxf-jaxws-service-and-client-config.xml"}, {"cxf-jaxws-service-and-client-config-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.config;
    }

    @Test
    public void jaxWsClientReadsMuleMethodPropertySetByJaxWsService() throws Exception {
        String url = "http://localhost:" + this.port.getNumber() + "/hello";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(url, this.getTestMuleMessage(REQUEST_PAYLOAD), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertEquals((Object)RESPONSE_PAYLOAD, (Object)result.getPayloadAsString());
    }

    @Test
    public void jaxWsServerWithMtoMServiceHasCorrectContentType() throws Exception {
        String url = "http://localhost:" + this.port.getNumber() + "/helloMtoM";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(url, this.getTestMuleMessage(REQUEST_PAYLOAD), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertThat((Object)result.getDataType().getMimeType(), (Matcher)CoreMatchers.is((Object)"multipart/related"));
        Assert.assertThat((Object)result.getPayload(), (Matcher)Is.is((Object)NullPayload.getInstance()));
        DataHandler part = result.getInboundAttachment((String)result.getInboundAttachmentNames().iterator().next());
        Assert.assertThat((Object)IOUtils.toString((InputStream)part.getInputStream(), (Charset)Charset.forName("UTF-8")), (Matcher)CoreMatchers.containsString((String)RESPONSE_PAYLOAD));
    }
}

