/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.issues;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.api.transport.PropertyScope;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

@RunWith(value=Parameterized.class)
public class ProxyMule6829TestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"proxy-mule-6829.xml"}, {"proxy-mule-6829-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testProxyServerSoap11() throws Exception {
        Latch latch = new Latch();
        TestCxfEventCallback testCxfEventCallback = new TestCxfEventCallback(latch);
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent("soap11Flow");
        testComponent.setEventCallback((EventCallback)testCxfEventCallback);
        String msgEchoOperation1 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        String msgEchoOperation2 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter2>hello world</new:parameter2>  </soapenv:Body></soapenv:Envelope>";
        String soapOperation = "EchoOperation1";
        MuleMessage response = this.executeSoap11Call(msgEchoOperation1, soapOperation);
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        String cxfOperationName = testCxfEventCallback.getCxfOperationName();
        Assert.assertEquals((Object)soapOperation, (Object)cxfOperationName);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<new:parameter1"));
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("hello world"));
        soapOperation = "EchoOperation2";
        response = this.executeSoap11Call(msgEchoOperation2, soapOperation);
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        cxfOperationName = testCxfEventCallback.getCxfOperationName();
        Assert.assertEquals((Object)soapOperation, (Object)cxfOperationName);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<new:parameter2"));
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("hello world"));
    }

    @Test
    public void testProxyServerSoap12() throws Exception {
        Latch latch = new Latch();
        TestCxfEventCallback testCxfEventCallback = new TestCxfEventCallback(latch);
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent("soap12Flow");
        testComponent.setEventCallback((EventCallback)testCxfEventCallback);
        String msgEchoOperation1 = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:new=\"http://new.webservice.namespace\"><soap:Header/>  <soap:Body>    <new:parameter1>hello world</new:parameter1>  </soap:Body></soap:Envelope>";
        String msgEchoOperation2 = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:new=\"http://new.webservice.namespace\"><soap:Header/>  <soap:Body>    <new:parameter2>hello world</new:parameter2>  </soap:Body></soap:Envelope>";
        String soapOperation = "EchoOperation1";
        MuleMessage response = this.executeSoap12Call(msgEchoOperation1, soapOperation);
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        String cxfOperationName = testCxfEventCallback.getCxfOperationName();
        Assert.assertEquals((Object)soapOperation, (Object)cxfOperationName);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<new:parameter1"));
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("hello world"));
        soapOperation = "EchoOperation2";
        response = this.executeSoap12Call(msgEchoOperation2, soapOperation);
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        cxfOperationName = testCxfEventCallback.getCxfOperationName();
        Assert.assertEquals((Object)soapOperation, (Object)cxfOperationName);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<new:parameter2"));
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("hello world"));
    }

    private MuleMessage executeSoap11Call(String msgString, String soapAction) throws MuleException {
        MuleMessage msg = this.getTestMuleMessage(msgString);
        msg.setProperty("soapAction", (Object)soapAction, PropertyScope.OUTBOUND);
        return muleContext.getClient().send("http://localhost:" + this.dynamicPort.getNumber() + "/EchoService11", msg, (OperationOptions)HTTP_REQUEST_OPTIONS);
    }

    private MuleMessage executeSoap12Call(String msgString, String soapAction) throws MuleException {
        MuleMessage msg = this.getTestMuleMessage(msgString);
        String contentType = "application/soap+xml;charset=UTF-8;action=\"" + soapAction + "\"";
        msg.setProperty("Content-Type", (Object)contentType, PropertyScope.OUTBOUND);
        return muleContext.getClient().send("http://localhost:" + this.dynamicPort.getNumber() + "/EchoService12", msg, (OperationOptions)HTTP_REQUEST_OPTIONS);
    }

    private static class TestCxfEventCallback
    implements EventCallback {
        private Latch latch;
        private String cxfOperationName;

        private TestCxfEventCallback(Latch latch) {
            this.latch = latch;
        }

        public void eventReceived(MuleEventContext context, Object component) throws Exception {
            QName cxfOperation = (QName)context.getMessage().getProperty("cxf_operation", PropertyScope.INVOCATION);
            this.cxfOperationName = cxfOperation.getLocalPart();
            this.latch.countDown();
        }

        public String getCxfOperationName() {
            return this.cxfOperationName;
        }
    }
}

