/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.issues;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@RunWith(value=Parameterized.class)
public class ProxyServiceImportTypesMule7883
extends FunctionalTestCase {
    @Rule
    public final DynamicPort httpPort = new DynamicPort("port1");
    @Parameterized.Parameter(value=0)
    public String config;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"issues/proxy-wsdl-import-conf.xml"}, {"issues/proxy-wsdl-import-conf-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.config;
    }

    @Test
    public void testWsdlImportType() throws Exception {
        this.testImportType("?wsdl", "?wsdl=TestTypeDefinitions.wsdl", "wsdl", "location");
    }

    @Test
    public void testXsdImportType() throws Exception {
        this.testImportType("?wsdl=TestTypeDefinitions.wsdl", "?xsd=TestSchema.xsd", "xsd", "schemaLocation");
    }

    private void testImportType(String targetUrl, String expectedImportUrl, String importType, String locationAttributeName) throws Exception {
        String proxyAddress = "http://localhost:" + this.httpPort.getNumber() + "/test";
        MuleMessage response = muleContext.getClient().send(proxyAddress + targetUrl, this.getTestMuleMessage(NullPayload.getInstance()));
        Document wsdl = XMLUnit.buildTestDocument((InputSource)new InputSource(new StringReader(response.getPayloadAsString())));
        List imports = DOMUtils.findAllElementsByTagName((Element)wsdl.getDocumentElement(), (String)(importType + ":import"));
        Assert.assertThat((Object)((Element)imports.get(0)).getAttribute(locationAttributeName), (Matcher)CoreMatchers.is((Object)(proxyAddress + expectedImportUrl)));
    }
}

