/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.jaxws;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;

public class CxfJaxWsTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "jaxws-conf.xml";
    }

    @Test
    public void testEchoService() throws Exception {
        String url = "cxf:http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo?method=echo";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(url, (Object)"Hello!", null);
        Assert.assertEquals((Object)"Hello!", (Object)result.getPayload());
    }

    @Test
    public void testOneWay() throws Exception {
        String url = "cxf:http://localhost:" + this.dynamicPort.getNumber() + "/services/async?method=send";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(url, (Object)"Hello!", null);
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)result.getPayload());
    }

    @Test
    public void testHttpCall() throws Exception {
        HttpClient client = new HttpClient();
        GetMethod httpMethod = new GetMethod("http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo/echo/text/hello");
        Assert.assertEquals((long)200L, (long)client.executeMethod((HttpMethod)httpMethod));
        Assert.assertEquals((Object)"<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:echoResponse xmlns:ns2=\"http://testmodels.cxf.module.mule.org/\"><text>hello</text></ns2:echoResponse></soap:Body></soap:Envelope>", (Object)httpMethod.getResponseBodyAsString());
    }

    @Test
    public void testWebServiceContext() throws Exception {
        String url = "cxf:http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo?method=ensureWebSerivceContextIsSet";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(url, (Object)"Test Message", null);
        Assert.assertEquals((Object)"Test Message", (Object)result.getPayload());
    }
}

