/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class CxfBadSoapRequestTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();

    public CxfBadSoapRequestTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "soap-request-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "soap-request-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "soap-request-conf-flow-httpn.xml"});
    }

    @Test
    public void testSoapDocumentError() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String soapRequest = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><ssss xmlns=\"http://www.muleumo.org\"><request xmlns=\"http://www.muleumo.org\">Bad Request</request></ssss></soap:Body></soap:Envelope>";
        MuleMessage reply = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/TestComponent", this.getTestMuleMessage(soapRequest), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)reply);
        Assert.assertNotNull((Object)reply.getPayload());
        String ct = (String)reply.getInboundProperty("Content-Type", (Object)"");
        Assert.assertEquals((Object)"text/xml; charset=UTF-8", (Object)ct);
        Document document = DocumentHelper.parseText((String)reply.getPayloadAsString());
        List fault = document.selectNodes("//soap:Envelope/soap:Body/soap:Fault/faultcode");
        Assert.assertEquals((long)1L, (long)fault.size());
        Element faultCodeElement = (Element)fault.get(0);
        Assert.assertEquals((Object)"soap:Client", (Object)faultCodeElement.getStringValue());
        fault = document.selectNodes("//soap:Envelope/soap:Body/soap:Fault/faultstring");
        Assert.assertEquals((long)1L, (long)fault.size());
        Element faultStringElement = (Element)fault.get(0);
        Assert.assertEquals((Object)"Message part {http://www.muleumo.org}ssss was not recognized.  (Does it exist in service WSDL?)", (Object)faultStringElement.getStringValue());
    }
}

