/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.config.i18n.LocaleMessageHandler;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class CxfBasicTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String BASIC_CONF_NEW_HTTP_FLOW_XML = "basic-conf-flow-httpn.xml";
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
    private String echoWsdl;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public CxfBasicTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "basic-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "basic-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, BASIC_CONF_NEW_HTTP_FLOW_XML});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.echoWsdl = IOUtils.getResourceAsString((String)"cxf-echo-service.wsdl", ((Object)((Object)this)).getClass()).replace("${port1}", this.dynamicPort.getValue());
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void testEchoService() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "application/soap+xml");
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo", (MuleMessage)new DefaultMuleMessage((Object)xml, props, muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertTrue((boolean)result.getPayloadAsString().contains("Hello!"));
        String ct = (String)result.getInboundProperty("Content-Type", (Object)"");
        Assert.assertEquals((Object)"text/xml; charset=UTF-8", (Object)ct);
    }

    @Test
    public void testEchoServiceEncoding() throws Exception {
        Assume.assumeThat((Object)this.configResources, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)BASIC_CONF_NEW_HTTP_FLOW_XML))));
        LocalMuleClient client = muleContext.getClient();
        String message = LocaleMessageHandler.getString((String)"test-data", (Locale)Locale.JAPAN, (String)"CxfBasicTestCase.testEchoServiceEncoding", (Object[])new Object[0]);
        MuleMessage result = client.send("cxf:http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo" + "?method=echo", this.getTestMuleMessage(message), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String ct = (String)result.getInboundProperty("Content-Type", (Object)"");
        Assert.assertEquals((Object)message, (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)"text/xml; charset=UTF-8", (Object)ct);
    }

    @Test
    public void testEchoWsdl() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo" + "?wsdl", this.getTestMuleMessage(null), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)result.getPayload());
        Diff wsdlComparation = XMLUnit.compareXML((String)this.echoWsdl, (String)result.getPayloadAsString());
        wsdlComparation.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
        Assert.assertThat((String)wsdlComparation.toString(), (Object)wsdlComparation.similar(), (Matcher)Matchers.is((Object)true));
    }
}

