/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class DatabindingTestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
    private static final String DATABINDING_CONF_HTTPN_XML = "databinding-conf-httpn.xml";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Parameterized.Parameter(value=0)
    public String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"databinding-conf.xml"}, {DATABINDING_CONF_HTTPN_XML});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testEchoWsdl() throws Exception {
        Assume.assumeThat((Object)this.configFile, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)DATABINDING_CONF_HTTPN_XML))));
        this.doTest("Echo");
    }

    @Test
    public void testEchoWsdlAegisBinding() throws Exception {
        this.doTest("aegis");
    }

    @Test
    public void testEchoWsdlSourceBinding() throws Exception {
        this.doTest("source");
    }

    @Test
    public void testEchoWsdlJaxbBinding() throws Exception {
        this.doTest("jaxb");
    }

    @Test
    public void testEchoWsdlJibxBinding() throws Exception {
        this.doTest("jibx");
    }

    @Test
    public void testEchoWsdlStaxBinding() throws Exception {
        this.doTest("stax");
    }

    @Test
    public void testEchoWsdlCustomBinding() throws Exception {
        this.doTest("custom");
    }

    private void doTest(String service) throws Exception {
        MuleMessage result = muleContext.getClient().send(String.format("http://localhost:%d/services/%s?wsdl", this.dynamicPort.getNumber(), service), this.getTestMuleMessage(null), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)result.getPayload());
    }
}

