/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

@RunWith(value=Parameterized.class)
public class GZIPEncodingTestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
    private static final String GZIP = "gzip";
    @Rule
    public final DynamicPort httpPort = new DynamicPort("port1");
    @Rule
    public final DynamicPort httpPortProxy = new DynamicPort("port2");
    private String getAllRequest;
    private String getAllResponse;
    @Parameterized.Parameter(value=0)
    public String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"gzip-encoding-conf.xml"}, {"gzip-encoding-conf-httpn.xml"});
    }

    @Before
    public void doSetUp() throws Exception {
        this.getAllRequest = IOUtils.getResourceAsString((String)"artistregistry-get-all-request.xml", ((Object)((Object)this)).getClass());
        this.getAllResponse = IOUtils.getResourceAsString((String)"artistregistry-get-all-response.xml", ((Object)((Object)this)).getClass());
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void proxyWithGZIPResponse() throws Exception {
        MuleMessage response = muleContext.getClient().send("http://localhost:" + this.httpPortProxy.getNumber() + "/proxy", this.getTestMuleMessage(this.getAllRequest), (OperationOptions)HTTP_REQUEST_OPTIONS);
        this.validateResponse(response);
    }

    @Test
    public void proxyWithGZIPRequestAndResponse() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Content-Encoding", "gzip,deflate");
        MuleMessage response = muleContext.getClient().send("http://localhost:" + this.httpPortProxy.getNumber() + "/proxy", (MuleMessage)new DefaultMuleMessage((Object)this.gzip(this.getAllRequest), properties, muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        this.validateResponse(response);
    }

    private void validateResponse(MuleMessage response) throws Exception {
        String unzipped = this.unzip(new ByteArrayInputStream(response.getPayloadAsBytes()));
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)this.getAllResponse, (String)unzipped).identical());
        Assert.assertEquals((Object)GZIP, (Object)response.getInboundProperty("Content-Encoding"));
    }

    private String unzip(InputStream input) throws IOException {
        int length;
        GZIPInputStream gzip = new GZIPInputStream(input);
        InputStreamReader reader = new InputStreamReader(gzip);
        StringWriter writer = new StringWriter();
        char[] buffer = new char[10240];
        while ((length = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, length);
        }
        writer.close();
        return writer.toString();
    }

    private byte[] gzip(String input) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(os);
        gzip.write(input.getBytes());
        gzip.close();
        return os.toByteArray();
    }
}

