/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.module.cxf.AbstractHttpSecurityTestCase;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpSecurityFilterFunctionalTestCase
extends AbstractHttpSecurityTestCase {
    @Rule
    public SystemProperty disablePropertiesMapping = new SystemProperty("mule.tls.disableSystemPropertiesMapping", "false");
    private static String soapRequest = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:unk=\"http://unknown.namespace/\"><soapenv:Header/><soapenv:Body><unk:echo><arg0>asdf</arg0></unk:echo></soapenv:Body></soapenv:Envelope>";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpSecurityFilterFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-security-filter-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-security-filter-test-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-security-filter-test-flow-httpn.xml"});
    }

    @Test
    public void testAuthenticationFailureBadCredentialsGetHttps() throws Exception {
        this.doGet(null, "localhost", "anonX", "anonX", "https://localhost:" + this.dynamicPort2.getNumber() + "/services/Echo", true, 401);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationFailureNoContextGet() throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        GetMethod get = new GetMethod("http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo");
        get.setDoAuthentication(false);
        try {
            int status = client.executeMethod((HttpMethod)get);
            Assert.assertEquals((long)401L, (long)status);
            Assert.assertThat((Object)get.getResponseBodyAsString(), (Matcher)Matchers.startsWith((String)"Registered authentication is set to org.mule.module.spring.security.filters.http.HttpBasicAuthenticationFilter but there was no security context on the session. Authentication denied on endpoint"));
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationFailureNoContextPost() throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        PostMethod post = new PostMethod("http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo");
        post.setDoAuthentication(false);
        StringRequestEntity requestEntity = new StringRequestEntity(soapRequest, "text/xml", "UTF-8");
        post.setRequestEntity((RequestEntity)requestEntity);
        try {
            int status = client.executeMethod((HttpMethod)post);
            Assert.assertEquals((long)401L, (long)status);
            Assert.assertThat((Object)post.getResponseBodyAsString(), (Matcher)Matchers.startsWith((String)"Registered authentication is set to org.mule.module.spring.security.filters.http.HttpBasicAuthenticationFilter but there was no security context on the session. Authentication denied on endpoint"));
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testAuthenticationFailureBadCredentialsGet() throws Exception {
        this.doGet(null, "localhost", "anonX", "anonX", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo/echo/echo/hello", true, 401);
    }

    @Test
    public void testAuthenticationFailureBadCredentialsPost() throws Exception {
        this.doPost(null, "localhost", "anonX", "anonX", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo", true, 401);
    }

    @Test
    public void testAuthenticationFailureBadCredentialsPostHttps() throws Exception {
        this.doPost(null, "localhost", "anonX", "anonX", "https://localhost:" + this.dynamicPort2.getNumber() + "/services/Echo", true, 401);
    }

    @Test
    public void testAuthenticationAuthorisedGet() throws Exception {
        this.doGet(null, "localhost", "anon", "anon", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo/echo/echo/hello", false, 200);
    }

    @Test
    public void testAuthenticationAuthorisedGetHttps() throws Exception {
        this.doGet(null, "localhost", "anon", "anon", "https://localhost:" + this.dynamicPort2.getNumber() + "/services/Echo/echo/echo/hello", false, 200);
    }

    @Test
    public void testAuthenticationAuthorisedPost() throws Exception {
        this.doPost(null, "localhost", "anon", "anon", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo", false, 200);
    }

    @Test
    public void testAuthenticationAuthorisedPostHttps() throws Exception {
        this.doPost(null, "localhost", "anon", "anon", "https://localhost:" + this.dynamicPort2.getNumber() + "/services/Echo", false, 200);
    }

    @Test
    public void testAuthenticationAuthorisedWithHandshakeGet() throws Exception {
        this.doGet(null, "localhost", "anon", "anon", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo/echo/echo/hello", true, 200);
    }

    @Test
    public void testAuthenticationAuthorisedWithHandshakePost() throws Exception {
        this.doPost(null, "localhost", "anon", "anon", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo", true, 200);
    }

    @Ignore
    @Test
    public void testAuthenticationAuthorisedWithHandshakeAndBadRealmGet() throws Exception {
        this.doGet("blah", "localhost", "anon", "anon", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo/echo/echo/hello", true, 401);
    }

    @Ignore
    @Test
    public void testAuthenticationAuthorisedWithHandshakeAndBadRealmPost() throws Exception {
        this.doPost("blah", "localhost", "anon", "anon", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo", true, 401);
    }

    @Test
    public void testAuthenticationAuthorisedWithHandshakeAndRealmGet() throws Exception {
        this.doGet("mule-realm", "localhost", "ross", "ross", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo/echo/echo/hello", true, 200);
    }

    @Test
    public void testAuthenticationAuthorisedWithHandshakeAndRealmPost() throws Exception {
        this.doPost("mule-realm", "localhost", "ross", "ross", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/Echo", true, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGet(String realm, String host, String user, String pass, String url, boolean handshake, int result) throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(host, -1, realm), (Credentials)new UsernamePasswordCredentials(user, pass));
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(handshake);
        try {
            int status = client.executeMethod((HttpMethod)get);
            if (status == 401 && handshake) {
                status = client.executeMethod((HttpMethod)get);
            }
            Assert.assertEquals((long)result, (long)status);
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPost(String realm, String host, String user, String pass, String url, boolean handshake, int result) throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(host, -1, realm), (Credentials)new UsernamePasswordCredentials(user, pass));
        PostMethod post = new PostMethod(url);
        post.setDoAuthentication(handshake);
        StringRequestEntity requestEntity = new StringRequestEntity(soapRequest, "text/xml", "UTF-8");
        post.setRequestEntity((RequestEntity)requestEntity);
        try {
            int status = client.executeMethod((HttpMethod)post);
            if (status == 401 && handshake) {
                status = client.executeMethod((HttpMethod)post);
            }
            Assert.assertEquals((long)result, (long)status);
            Assert.assertNotNull((Object)post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
    }
}

