/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.cxf.AbstractHttpSecurityTestCase;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpSecurityTestCase
extends AbstractHttpSecurityTestCase {
    @Rule
    public SystemProperty disablePropertiesMapping = new SystemProperty("mule.tls.disableSystemPropertiesMapping", "false");
    private static final String HTTP_SECURITY_CONF_FLOW_HTTPN_XML = "http-security-conf-flow-httpn.xml";
    private static String soapRequest = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:unk=\"http://unknown.namespace/\"><soapenv:Header/><soapenv:Body><unk:echo><arg0>asdf</arg0></unk:echo></soapenv:Body></soapenv:Envelope>";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpSecurityTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-security-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-security-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, HTTP_SECURITY_CONF_FLOW_HTTPN_XML});
    }

    @Test
    public void testBasicAuth() throws Exception {
        HttpClient client = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin", "admin");
        client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        client.getParams().setAuthenticationPreemptive(true);
        PostMethod method = new PostMethod("https://localhost:" + this.dynamicPort2.getNumber() + "/services/Echo");
        method.setDoAuthentication(true);
        StringRequestEntity requestEntity = new StringRequestEntity(soapRequest, "text/plain", "UTF-8");
        method.setRequestEntity((RequestEntity)requestEntity);
        int result = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)result);
        credentials = new UsernamePasswordCredentials("admin", "adminasd");
        client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        client.getParams().setAuthenticationPreemptive(true);
        result = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)401L, (long)result);
    }

    @Test
    public void testBasicAuthWithCxfClient() throws Exception {
        Assume.assumeThat((Object)this.configResources, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)HTTP_SECURITY_CONF_FLOW_HTTPN_XML))));
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("cxf:http://admin:admin@localhost:" + this.dynamicPort1.getNumber() + "/services/Echo?method=echo", this.getTestMuleMessage("Hello"));
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        Assert.assertEquals((long)200L, (long)status);
    }
}

