/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.apache.cxf.helpers.DOMUtils;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@RunWith(value=Parameterized.class)
public class ProxyWSDLRewriteAddressTestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    @Rule
    public final DynamicPort httpPort = new DynamicPort("port1");
    private static final String SINGLE_PORT = "StockQuoteSoap";
    private static final String SERVICE_LOCATION = "http://www.webservicex.net/stockquote.asmx";
    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"proxy-wsdl-rewrite-address-conf.xml"}, {"proxy-wsdl-rewrite-address-conf-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testProxyWSDLRewriteSinglePort() throws Exception {
        String proxyAddress = "http://localhost:" + this.httpPort.getNumber() + "/single";
        MuleMessage response = muleContext.getClient().send(proxyAddress + "?wsdl", this.getTestMuleMessage(NullPayload.getInstance()), (OperationOptions)HTTP_REQUEST_OPTIONS);
        for (Element port : this.getPorts(this.getWsdl(response))) {
            String location = this.getLocation(port);
            String portName = port.getAttribute("name");
            if (SINGLE_PORT.equals(portName)) {
                Assert.assertEquals((String)proxyAddress, (String)location);
                continue;
            }
            Assert.assertEquals((String)SERVICE_LOCATION, (String)location);
        }
    }

    @Test
    public void testProxyWSDLRewriteAllPorts() throws Exception {
        String proxyAddress = "http://localhost:" + this.httpPort.getNumber() + "/all";
        MuleMessage response = muleContext.getClient().send(proxyAddress + "?wsdl", this.getTestMuleMessage(NullPayload.getInstance()), (OperationOptions)HTTP_REQUEST_OPTIONS);
        for (Element port : this.getPorts(this.getWsdl(response))) {
            Assert.assertEquals((String)proxyAddress, (String)this.getLocation(port));
        }
    }

    private Document getWsdl(MuleMessage response) throws Exception {
        return XMLUnit.buildTestDocument((InputSource)new InputSource(new StringReader(response.getPayloadAsString())));
    }

    private List<Element> getPorts(Document wsdl) {
        return DOMUtils.findAllElementsByTagName((Element)wsdl.getDocumentElement(), (String)"wsdl:port");
    }

    private String getLocation(Element port) {
        return port.getFirstChild().getNextSibling().getAttributes().getNamedItem("location").getNodeValue();
    }
}

