/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@RunWith(value=Parameterized.class)
public class ProxyWSDLRewriteSchemaLocationsTestCase
extends FunctionalTestCase {
    @Rule
    public final DynamicPort httpPortProxy = new DynamicPort("portProxy");
    @Rule
    public final DynamicPort httpPortMockServer = new DynamicPort("portMockServer");
    @Parameterized.Parameter(value=0)
    public String config;
    @Parameterized.Parameter(value=1)
    public String serverConfig;
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
    private MuleContext mockServerContext;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"wsdlAndXsdMockServer/proxy-wsdl-rewrite-schema-locations-conf.xml", "wsdlAndXsdMockServer/proxy-wsdl-rewrite-schema-locations-conf-server.xml"}, {"wsdlAndXsdMockServer/proxy-wsdl-rewrite-schema-locations-conf-httpn.xml", "wsdlAndXsdMockServer/proxy-wsdl-rewrite-schema-locations-conf-server-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.config;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        ApplicationContextBuilder applicationContextBuilder = new ApplicationContextBuilder();
        applicationContextBuilder.setApplicationResources(new String[]{this.serverConfig});
        this.mockServerContext = applicationContextBuilder.build();
        super.doSetUpBeforeMuleContextCreation();
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        super.doTearDownAfterMuleContextDispose();
        if (this.mockServerContext != null) {
            this.mockServerContext.dispose();
        }
    }

    @Test
    public void testProxyWSDLRewriteAllSchemaLocations() throws Exception {
        String proxyAddress = "http://localhost:" + this.httpPortProxy.getNumber() + "/localServicePath";
        MuleMessage response = muleContext.getClient().send(proxyAddress + "?wsdl", this.getTestMuleMessage(NullPayload.getInstance()), (OperationOptions)HTTP_REQUEST_OPTIONS);
        HashSet<String> expectedParametersValues = new HashSet<String>();
        expectedParametersValues.addAll(Arrays.asList("xsd=xsd0"));
        List<Element> schemaImports = this.getSchemaImports(this.getWsdl(response));
        for (Element schemaImport : schemaImports) {
            String schemaLocation = this.getLocation(schemaImport);
            int parametersStart = schemaLocation.indexOf("?");
            String locationPath = schemaLocation.substring(0, parametersStart);
            Assert.assertEquals((Object)proxyAddress, (Object)locationPath);
            String queryString = schemaLocation.substring(parametersStart + 1);
            expectedParametersValues.remove(queryString);
        }
        Assert.assertTrue((boolean)expectedParametersValues.isEmpty());
    }

    private Document getWsdl(MuleMessage response) throws Exception {
        return XMLUnit.buildTestDocument((InputSource)new InputSource(new StringReader(response.getPayloadAsString())));
    }

    private List<Element> getSchemaImports(Document wsdl) {
        return DOMUtils.findAllElementsByTagName((Element)wsdl.getDocumentElement(), (String)"xsd:import");
    }

    private String getLocation(Element schemaImport) {
        return schemaImport.getAttributes().getNamedItem("schemaLocation").getNodeValue();
    }
}

