/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class ProxyWithValidationTestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    public static final String SAMPLE_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <echo xmlns=\"http://www.muleumo.org\">  <echo><![CDATA[bla]]></echo></echo></soap:Body></soap:Envelope>";
    @Rule
    public final DynamicPort httpPort = new DynamicPort("port1");
    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"proxy-with-validation-config.xml"}, {"proxy-with-validation-config-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void acceptsRequestWithCData() throws Exception {
        MuleMessage response = muleContext.getClient().send("http://localhost:" + this.httpPort.getNumber() + "/services/Echo", this.getTestMuleMessage(SAMPLE_REQUEST), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("bla"));
    }
}

