/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.File;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.config.ConfigResource;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class WSProxyTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");

    protected String getConfigFile() {
        return "mule-proxy-config.xml";
    }

    @Test
    @Ignore(value="WSProxyService class is intended only for Services, which are deprecated. CXF 2.7.15 version performs some parameters validation that make this test to fail.")
    public void testDirectRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("wsdl-cxf:http://localhost:" + this.dynamicPort1.getNumber() + "/WebService?wsdl&method=echo", this.getTestMuleMessage("mule"));
        Assert.assertEquals((Object)"mule", (Object)result.getPayloadAsString());
    }

    @Test
    public void testWsdlProxyRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        MuleMessage replyMessage = client.send("http://localhost:" + this.dynamicPort2.getNumber() + "/webServiceProxy?wsdl", (Object)"/services/webServiceProxy?WSDL", props);
        Assert.assertNotNull((Object)replyMessage);
        String wsdl = replyMessage.getPayloadAsString();
        Assert.assertNotNull((Object)wsdl);
        Assert.assertTrue((wsdl.indexOf("<wsdl:definitions") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((wsdl.indexOf("<wsdl:message name=\"echoResponse\">") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((wsdl.indexOf("<wsdl:message name=\"echo\">") != -1 ? 1 : 0) != 0);
    }

    @Test
    @Ignore(value="WSProxyService class is intended only for Services, which are deprecated. CXF 2.7.15 version performs some parameters validation that make this test to fail.")
    public void testProxyRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("wsdl-cxf:http://localhost:" + this.dynamicPort2.getNumber() + "/webServiceProxy?wsdl&method=echo", this.getTestMuleMessage("mule"));
        Assert.assertEquals((Object)"mule", (Object)result.getPayloadAsString());
    }

    @Test
    public void testWsdlFileRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        MuleMessage replyMessage = client.send("http://localhost:" + this.dynamicPort3.getNumber() + "/webServiceProxy?wsdl", (Object)"/services/webServiceProxy?WSDL", props);
        Assert.assertNotNull((Object)replyMessage);
        String wsdl = replyMessage.getPayloadAsString();
        Assert.assertNotNull((Object)wsdl);
        Assert.assertTrue((wsdl.indexOf("<wsdl:definitions") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((wsdl.indexOf("<wsdl:message name=\"echoResponse\">") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((wsdl.indexOf("<wsdl:message name=\"echo\">") != -1 ? 1 : 0) != 0);
    }

    @Test
    @Ignore(value="WSProxyService class is intended only for Services, which are deprecated. CXF 2.7.15 version performs some parameters validation that make this test to fail.")
    public void testWsdlFileProxyRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("wsdl-cxf:http://localhost:" + this.dynamicPort3.getNumber() + "/webServiceProxy?wsdl&method=echo", this.getTestMuleMessage("mule"));
        Assert.assertEquals((Object)"mule", (Object)result.getPayloadAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="WSProxyService class is intended only for Services, which are deprecated. CXF 2.7.15 version performs some parameters validation that make this test to fail.")
    public void testWsdlFileNotReloaded() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("wsdl-cxf:http://localhost:" + this.dynamicPort3.getNumber() + "/webServiceProxy?wsdl&method=echo", this.getTestMuleMessage("mule"));
        Assert.assertEquals((Object)"mule", (Object)result.getPayloadAsString());
        String wsdlFileName = "wsproxyservice-localWsdl.wsdl";
        ConfigResource wsdlFileResource = new ConfigResource(wsdlFileName);
        String wsdlFilePathname = wsdlFileResource.getUrl().getFile();
        String tmpWsdlFilePathname = wsdlFilePathname + ".tmp";
        File wsdlFile = new File(wsdlFilePathname);
        Assert.assertTrue((boolean)wsdlFile.exists());
        Assert.assertTrue((boolean)wsdlFile.renameTo(new File(tmpWsdlFilePathname)));
        try {
            Assert.assertFalse((boolean)new File(wsdlFilePathname).exists());
            result = client.send("wsdl-cxf:http://localhost:" + this.dynamicPort3.getNumber() + "/webServiceProxy?wsdl&method=echo", this.getTestMuleMessage("mule"));
            Assert.assertEquals((Object)"mule", (Object)result.getPayloadAsString());
        }
        finally {
            new File(tmpWsdlFilePathname).renameTo(new File(wsdlFilePathname));
        }
    }
}

