/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.builder.SimpleClientMessageProcessorBuilder;
import org.mule.module.cxf.config.WsConfig;
import org.mule.module.cxf.config.WsSecurity;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SimpleClientMessageProcessorBuilderTestCase
extends AbstractMuleContextTestCase {
    private SimpleClientMessageProcessorBuilder simpleClientMessageProcessorBuilder;
    private static final String SERVICE_CLASS = "org.mule.module.cxf.testmodels.Echo";

    @Before
    public void setUp() {
        this.simpleClientMessageProcessorBuilder = new SimpleClientMessageProcessorBuilder();
    }

    @Test
    public void testWsSecurityConfig() throws MuleException {
        WsSecurity wsSecurity = new WsSecurity();
        this.addConfigProperties(wsSecurity);
        this.simpleClientMessageProcessorBuilder.setWsSecurity(wsSecurity);
        this.simpleClientMessageProcessorBuilder.setServiceClass(SERVICE_CLASS.getClass());
        this.simpleClientMessageProcessorBuilder.setMuleContext(muleContext);
        CxfOutboundMessageProcessor messageProcessor = this.simpleClientMessageProcessorBuilder.build();
        Assert.assertNotNull((Object)messageProcessor);
        WSS4JOutInterceptor wss4JOutInterceptor = this.getInterceptor(messageProcessor.getClient().getOutInterceptors());
        Assert.assertNotNull((Object)wss4JOutInterceptor);
        Map wss4jProperties = wss4JOutInterceptor.getProperties();
        Assert.assertFalse((boolean)wss4jProperties.isEmpty());
        Assert.assertEquals((Object)"UsernameToken", wss4jProperties.get("action"));
    }

    private WSS4JOutInterceptor getInterceptor(List<Interceptor<? extends Message>> interceptors) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!(interceptor instanceof WSS4JOutInterceptor)) continue;
            return (WSS4JOutInterceptor)interceptor;
        }
        return null;
    }

    private void addConfigProperties(WsSecurity wsSecurity) {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        configProperties.put("action", "UsernameToken");
        wsSecurity.setWsConfig(new WsConfig(configProperties));
    }
}

