/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.functional;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.SensingNullRequestResponseMessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class CxfContentTypeNonBlockingTestCase
extends FunctionalTestCase {
    private static final String requestPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "cxf-echo-service-conf-httpn-nb.xml";
    }

    @Test
    public void testCxfService() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/hello", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        String contentType = (String)received.getInboundProperty("content-type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.contains("charset"));
    }

    @Test
    public void testCxfClient() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/helloClient", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        String contentType = (String)received.getInboundProperty("contentType");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.contains("charset"));
        this.getSensingInstance("sensingRequestResponseProcessor").assertRequestResponseThreadsDifferent();
    }

    @Test
    public void testCxfClientProxy() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage received = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/helloClientProxy", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        String contentType = (String)received.getInboundProperty("contentType");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.contains("charset"));
        this.getSensingInstance("sensingRequestResponseProcessorProxy").assertRequestResponseThreadsDifferent();
    }

    private SensingNullRequestResponseMessageProcessor getSensingInstance(String instanceBeanName) {
        return (SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(instanceBeanName);
    }
}

