/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.jws.WebService;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.cxf.example.HelloWorld;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class UnwrapsComponentExceptionTestCase
extends FunctionalTestCase {
    public static final String ERROR_MESSAGE = "Changos!!!";
    private static final String requestPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"unwraps-component-exception-config.xml"}, {"unwraps-component-exception-config-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testReceivesComponentExceptionMessage() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        MuleMessage received = muleContext.getClient().send("http://localhost:" + this.dynamicPort.getNumber() + "/hello", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertTrue((String)"Component exception was not managed", (boolean)received.getPayloadAsString().contains(ERROR_MESSAGE));
    }

    @WebService(endpointInterface="org.mule.module.cxf.example.HelloWorld", serviceName="HelloWorld")
    public static class HelloWorldImpl
    implements HelloWorld {
        @Override
        public String sayHi(String text) {
            throw new RuntimeException(UnwrapsComponentExceptionTestCase.ERROR_MESSAGE);
        }
    }
}

