/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.issues;

import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.size.SmallTest;
import org.mule.util.IOUtils;

@SmallTest
public class CxfClientRaceConditionTestCase
extends FunctionalTestCase {
    private static final String HTTP_METHOD = "httpTest";
    private static final String HTTP_HOST = "localhost";
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    private static final String EXPECTED_JMS_MESSAGE = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\"><soap:Body/></soap:Envelope>";
    private static final String HTTP_REQUEST_BODY = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:ns=\"http://dummy.org\"><soap:Body/><ns:dummy></ns:dummy></soap:Envelope>";
    private static final String EXPECTED_HTTP_MESSAGE = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\"><soap:Body><ns:dummy xmlns:ns=\"http://dummy.org\"/></soap:Body></soap:Envelope>";
    private static final String INBOUND_TEST_QUEUE = "inboundTest";
    private static final String OUTBOUND_TEST_QUEUE = "cxfTest";
    private static final String JMS_CONNECTION_ADDRESS = "vm://localhost";
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    private int totalMessages;

    @Before
    public void setup() {
        this.totalMessages = 10000;
    }

    @Test
    public void testRaceConditionHTTP() throws Exception {
        this.cxfHTTPTest("http", HTTP_HOST, this.port1.getNumber(), HTTP_METHOD, HTTP_REQUEST_OPTIONS, EXPECTED_HTTP_MESSAGE);
    }

    @Test
    public void testRaceConditionJMS() throws Exception {
        this.cxfJMSTest(INBOUND_TEST_QUEUE, OUTBOUND_TEST_QUEUE, EXPECTED_JMS_MESSAGE);
    }

    private void cxfJMSTest(String inboundQueue, String outboundQueue, String expectedMessage) throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(JMS_CONNECTION_ADDRESS);
        Connection consumerConnection = connectionFactory.createConnection();
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(false, 1);
        Queue consumerDestination = consumerSession.createQueue(outboundQueue);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerDestination);
        Connection producerConnection = connectionFactory.createConnection();
        producerConnection.start();
        Session producerSession = producerConnection.createSession(false, 1);
        Queue producerDestination = producerSession.createQueue(inboundQueue);
        MessageProducer producer = producerSession.createProducer((Destination)producerDestination);
        producer.setDeliveryMode(1);
        for (int i = 0; i < this.totalMessages; ++i) {
            BytesMessage messageSend = producerSession.createBytesMessage();
            producer.send((Message)messageSend);
            Message messageReceived = consumer.receive(5000L);
            ActiveMQBytesMessage bytesMessage = (ActiveMQBytesMessage)messageReceived;
            String messageBody = new String(bytesMessage.getContent().getData());
            String messageTrimmed = messageBody.trim();
            MatcherAssert.assertThat((Object)messageTrimmed, (Matcher)CoreMatchers.equalTo((Object)expectedMessage));
        }
        producer.close();
        producerSession.close();
        producerConnection.close();
        consumer.close();
        consumerSession.close();
        consumerConnection.close();
    }

    private void cxfHTTPTest(String protocol, String host, Integer port, String method, HttpRequestOptions options, String expectedMessage) throws MuleException {
        for (int i = 0; i < this.totalMessages; ++i) {
            DefaultMuleMessage request = new DefaultMuleMessage((Object)HTTP_REQUEST_BODY, muleContext);
            LocalMuleClient client = muleContext.getClient();
            MuleMessage message = client.send(protocol + "://" + host + ":" + port + "/" + method, (MuleMessage)request, (OperationOptions)options);
            String response = IOUtils.toString((InputStream)((InputStream)message.getPayload()));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.equalTo((Object)expectedMessage));
        }
    }

    protected String getConfigResources() {
        return "issues/cxf-client-race-condition.xml";
    }
}

