/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.jaxws;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.construct.Flow;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class HeaderPropertiesTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Parameterized.Parameter(value=0)
    public String config;
    private static final String HEADER_CONF_HTTPN_XML = "header-conf-httpn.xml";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"header-conf.xml"}, {HEADER_CONF_HTTPN_XML});
    }

    protected String getConfigFile() {
        return this.config;
    }

    private GreeterImpl getGreeter() throws Exception {
        Object instance = this.getComponent("greeterService");
        return (GreeterImpl)instance;
    }

    @Test
    public void testClientWithMuleClient() throws Exception {
        FunctionalTestComponent testComponent = this.getFunctionalTestComponent("testService");
        Assert.assertNotNull((Object)testComponent);
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                MuleMessage msg = context.getMessage();
                Assert.assertEquals((Object)"BAR", (Object)msg.getInboundProperty("FOO"));
            }
        };
        testComponent.setEventCallback(callback);
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("operation", "greetMe");
        props.put("FOO", "BAR");
        MuleMessage result = this.config == HEADER_CONF_HTTPN_XML ? ((Flow)this.getFlowConstruct("clientFlow")).process(HeaderPropertiesTestCase.getTestEvent((Object)new DefaultMuleMessage((Object)"Dan", props, muleContext))).getMessage() : client.send("clientEndpoint", (Object)"Dan", props);
        Assert.assertEquals((Object)"Hello Dan Received", (Object)result.getPayload());
        GreeterImpl impl = this.getGreeter();
        Assert.assertEquals((long)1L, (long)impl.getInvocationCount());
    }
}

