/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.net.URL;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MuleServer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.ExceptionUtils;

public class ProxyServiceConfigurationTestCase
extends AbstractMuleTestCase {
    @Test
    public void testGetEndpointName_CorrectNameSpace() {
        String configFilePath = "/org/mule/module/cxf/support/test-proxy-mule-config-correct-namespace.xml";
        this.startServer(configFilePath);
    }

    @Test
    public void testGetEndpointName_NoNameSpace() {
        String configFilePath = "/org/mule/module/cxf/support/test-proxy-mule-config-no-namespace.xml";
        try {
            this.startServer(configFilePath);
            Assert.fail((String)"It should have failed because no namespace was specified");
        }
        catch (RuntimeException e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            Assert.assertTrue((String)("Exception must be of type " + ServiceConstructionException.class + ", instead of " + rootCause), (boolean)(rootCause instanceof ServiceConstructionException));
        }
    }

    private void startServer(String configFilePath) {
        URL configURL = ((Object)((Object)this)).getClass().getResource(configFilePath);
        MuleServer muleServer = new MuleServer(configURL.toString()){

            public void shutdown(Throwable e) {
                throw new RuntimeException(e);
            }
        };
        muleServer.start(false, false);
    }
}

