/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.InputStream;
import java.util.HashMap;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.SensingNullRequestResponseMessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class CxfBackToBlockingTestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
    private String echoWsdl;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "basic-conf-flow-httpn-nb.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.echoWsdl = IOUtils.getResourceAsString((String)"cxf-echo-service.wsdl", ((Object)((Object)this)).getClass()).replace("${port1}", this.dynamicPort.getValue());
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void backToBlocking() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "application/soap+xml");
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo", (MuleMessage)new DefaultMuleMessage((Object)xml, props, muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertTrue((boolean)result.getPayloadAsString().contains("Hello!"));
        String ct = (String)result.getInboundProperty("Content-Type", (Object)"");
        Assert.assertEquals((Object)"text/xml; charset=UTF-8", (Object)ct);
        ((SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(SensingNullRequestResponseMessageProcessor.class)).assertRequestResponseThreadsSame();
    }

    @Test
    public void backToBlockingWsdl() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo?wsdl", CxfBackToBlockingTestCase.getTestMuleMessage(null), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)result.getPayload());
        Diff wsdlComparation = XMLUnit.compareXML((String)this.echoWsdl, (String)result.getPayloadAsString());
        wsdlComparation.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
        Assert.assertThat((String)wsdlComparation.toString(), (Object)wsdlComparation.similar(), (Matcher)Is.is((Object)true));
        ((SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(SensingNullRequestResponseMessageProcessor.class)).assertRequestResponseThreadsSame();
    }
}

