/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class CxfConfigurationWsdlTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Parameterized.Parameter(value=0)
    public String config;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"cxf-configuration-wsdl-config.xml"}, {"cxf-configuration-wsdl-config-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.config;
    }

    @Test
    public void test() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(String.format("http://localhost:%s?wsdl", this.httpPort.getNumber()), CxfConfigurationWsdlTestCase.getTestMuleMessage(null), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build());
        String serviceLocation = String.format("<soap:address location=\"http://localhost:%s/\"/>", this.httpPort.getNumber());
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Matchers.containsString((String)serviceLocation));
    }
}

