/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.ServiceInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.OutputHandler;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfInboundMessageProcessor;
import org.mule.module.cxf.builder.WebServiceMessageProcessorBuilder;
import org.mule.module.cxf.support.ProxySchemaValidationInInterceptor;
import org.mule.module.cxf.support.StreamClosingInterceptor;
import org.mule.module.cxf.testmodels.Echo;
import org.mule.module.xml.stax.DelegateXMLStreamReader;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class CxfInboundMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    private String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns1:echo xmlns:ns1=\"http://testmodels.cxf.module.mule.org/\"><text>echo</text></ns1:echo></soap:Body></soap:Envelope>";
    private static final String ANOTHER_VALUE = "another value";
    private String responseMsg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:echoResponse xmlns:ns2=\"http://testmodels.cxf.module.mule.org/\"><text>another value</text></ns2:echoResponse></soap:Body></soap:Envelope>";
    private boolean gotEvent = false;
    Object payload;

    @Test
    public void testInbound() throws Exception {
        CxfInboundMessageProcessor processor = this.createCxfMessageProcessor();
        MessageProcessor messageProcessor = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                CxfInboundMessageProcessorTestCase.this.payload = event.getMessage().getPayload();
                Assert.assertEquals((Object)"echo", (Object)CxfInboundMessageProcessorTestCase.this.payload);
                event.getMessage().setPayload((Object)"echo");
                CxfInboundMessageProcessorTestCase.this.gotEvent = true;
                return event;
            }
        };
        processor.setListener(messageProcessor);
        MuleEvent event = CxfInboundMessageProcessorTestCase.getTestEvent((Object)this.msg, (InboundEndpoint)CxfInboundMessageProcessorTestCase.getTestInboundEndpoint((MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE));
        MuleEvent response = processor.process(event);
        Object payload = response.getMessage().getPayload();
        Assert.assertTrue((boolean)(payload instanceof OutputHandler));
        ((OutputHandler)payload).write(response, (OutputStream)System.out);
        Assert.assertTrue((boolean)this.gotEvent);
    }

    @Test
    public void testOneWay() throws Exception {
        CxfInboundMessageProcessor processor = this.createCxfMessageProcessor();
        MessageProcessor messageProcessor = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                CxfInboundMessageProcessorTestCase.this.payload = event.getMessage().getPayload();
                Assert.assertEquals((Object)"echo", (Object)CxfInboundMessageProcessorTestCase.this.payload);
                event.getMessage().setPayload((Object)"echo");
                CxfInboundMessageProcessorTestCase.this.gotEvent = true;
                return null;
            }
        };
        processor.setListener(messageProcessor);
        MuleEvent event = CxfInboundMessageProcessorTestCase.getTestEvent((Object)this.msg, (InboundEndpoint)CxfInboundMessageProcessorTestCase.getTestInboundEndpoint((MessageExchangePattern)MessageExchangePattern.ONE_WAY));
        MuleEvent response = processor.process(event);
        Assert.assertTrue((boolean)this.gotEvent);
        Assert.assertNull((Object)response);
    }

    private CxfInboundMessageProcessor createCxfMessageProcessor() throws MuleException {
        CxfConfiguration config = new CxfConfiguration();
        config.setMuleContext(muleContext);
        config.initialise();
        WebServiceMessageProcessorBuilder builder = new WebServiceMessageProcessorBuilder();
        builder.setConfiguration(config);
        builder.setServiceClass(Echo.class);
        builder.setMuleContext(muleContext);
        CxfInboundMessageProcessor processor = builder.build();
        processor.start();
        return processor;
    }

    @Test
    public void inboundWithValidationEnabled() throws Exception {
        CxfInboundMessageProcessor processor = this.createMessageProcessorWithValidationEnabled();
        MessageProcessor messageProcessor = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                CxfInboundMessageProcessorTestCase.this.payload = event.getMessage().getPayload();
                MatcherAssert.assertThat((Object)"echo", (Matcher)Matchers.equalTo((Object)CxfInboundMessageProcessorTestCase.this.payload));
                event.getMessage().setPayload((Object)CxfInboundMessageProcessorTestCase.ANOTHER_VALUE);
                return event;
            }
        };
        processor.setListener(messageProcessor);
        MuleEvent event = CxfInboundMessageProcessorTestCase.getTestEvent((Object)this.msg, (InboundEndpoint)CxfInboundMessageProcessorTestCase.getTestInboundEndpoint((MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE));
        MuleEvent response = processor.process(event);
        Object payload = response.getMessage().getPayload();
        MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.instanceOf(OutputHandler.class));
        MatcherAssert.assertThat((Object)response.getMessage().getPayloadAsString(), (Matcher)Matchers.is((Object)this.responseMsg));
    }

    private CxfInboundMessageProcessor createMessageProcessorWithValidationEnabled() throws MuleException {
        CxfConfiguration config = new CxfConfiguration();
        config.setMuleContext(muleContext);
        config.initialise();
        WebServiceMessageProcessorBuilder builder = new WebServiceMessageProcessorBuilder();
        builder.setConfiguration(config);
        builder.setServiceClass(Echo.class);
        builder.setMuleContext(muleContext);
        builder.getInInterceptors().add(new CustomInterceptorWithDelegateStreamReader());
        builder.setValidationEnabled(true);
        CxfInboundMessageProcessor processor = builder.build();
        Server server = processor.getServer();
        server.getEndpoint().getInInterceptors().add(new ProxySchemaValidationInInterceptor(config.getCxfBus(), server.getEndpoint(), (ServiceInfo)server.getEndpoint().getService().getServiceInfos().get(0)));
        processor.start();
        return processor;
    }

    private class CustomInterceptorWithDelegateStreamReader
    extends AbstractPhaseInterceptor<Message> {
        CustomInterceptorWithDelegateStreamReader() {
            super("post-stream");
            this.getAfter().add(StreamClosingInterceptor.class.getName());
            this.getAfter().add(StaxInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (reader != null) {
                DelegateXMLStreamReader replacement = new DelegateXMLStreamReader(reader);
                message.setContent(XMLStreamReader.class, (Object)replacement);
            }
        }
    }
}

