/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.interceptor.Fault;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.AbstractTransformer;
import org.mule.transport.NullPayload;

public class ExceptionStrategyTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String requestPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    private static final String requestFaultPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    private static final String EXCEPTION_STRATEGY_FLOW_CONF_HTTPN_XML = "exception-strategy-flow-conf-httpn.xml";
    private CountDownLatch latch;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public ExceptionStrategyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "exception-strategy-service-conf.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "exception-strategy-flow-conf.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, EXCEPTION_STRATEGY_FLOW_CONF_HTTPN_XML});
    }

    @Test
    public void testFaultInCxfService() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestFaultPayload, (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        this.latch = new CountDownLatch(1);
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener(){

            public void onNotification(ServerNotification notification) {
                ExceptionStrategyTestCase.this.latch.countDown();
            }
        });
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testServiceWithFault", (MuleMessage)request, (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<faultstring>"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)response.getInboundProperty("http.status").toString());
        Assert.assertTrue((boolean)this.latch.await(3000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testExceptionInCxfService() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        this.latch = new CountDownLatch(1);
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener(){

            public void onNotification(ServerNotification notification) {
                ExceptionStrategyTestCase.this.latch.countDown();
            }
        });
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/testServiceWithException", (MuleMessage)request, (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<faultstring>"));
        Assert.assertEquals((Object)String.valueOf(500), (Object)response.getInboundProperty("http.status").toString());
        Assert.assertTrue((boolean)this.latch.await(3000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testClientWithTransformerExceptionDefaultException() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testClientTransformerExceptionDefaultException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((response.getExceptionPayload() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(response.getExceptionPayload().getException() instanceof MessagingException));
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
    }

    @Test
    public void testClientWithFaultDefaultException() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testClientWithFaultDefaultException", (MuleMessage)request);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((response.getExceptionPayload() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(response.getExceptionPayload().getException().getCause() instanceof Fault));
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
    }

    @Test
    public void testServerClientProxyDefaultException() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        this.latch = new CountDownLatch(1);
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener(){

            public void onNotification(ServerNotification notification) {
                ExceptionStrategyTestCase.this.latch.countDown();
            }
        });
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/proxyExceptionStrategy", ExceptionStrategyTestCase.getTestMuleMessage((Object)requestPayload), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("<faultstring>"));
        if (this.configResources != EXCEPTION_STRATEGY_FLOW_CONF_HTTPN_XML) {
            Assert.assertTrue((response.getExceptionPayload() != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((Object)String.valueOf(500), (Object)response.getInboundProperty("http.status").toString());
        Assert.assertTrue((boolean)this.latch.await(3000L, TimeUnit.MILLISECONDS));
    }

    public static class CustomProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            return event;
        }
    }

    public static class CxfTransformerThrowsExceptions
    extends AbstractTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            throw new TransformerException(CoreMessages.failedToBuildMessage());
        }
    }
}

