/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.module.cxf.AbstractHttpSecurityTestCase;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpSecurityPolicyTestCase
extends AbstractHttpSecurityTestCase {
    private static String SOAP_REQUEST_OPEN = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:tes=\"http://testmodels.cxf.module.mule.org/\">";
    private static String SOAP_ENV_HEADER_OPEN = "<soapenv:Header>";
    private static String SOAP_ENV_HEADER_CLOSE = "</soapenv:Header>";
    String msgEchoOperation1 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
    private static String SOAP_BODY = "<soapenv:Body><tes:echo><text>echo</text></tes:echo></soapenv:Body>";
    private static String SOAP_REQUEST_CLOSE = "</soapenv:Envelope>";
    private static String SOAP_PROPERTY_USERNAME_TOKEN = "<wsse:Security soapenv:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><wsse:UsernameToken wsu:Id=\"UsernameToken-8424E70C4CDF89B5E514992807079293\"><wsse:Username>fabiang</wsse:Username><wsse:Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText\">password</wsse:Password><wsse:Nonce EncodingType=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary\">nFovTkBez8DceekL08FsQw==</wsse:Nonce></wsse:UsernameToken></wsse:Security>";
    private static String soapPropertyUsernameWrongPasswordToken = "<wsse:Security soapenv:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><wsse:UsernameToken wsu:Id=\"UsernameToken-8424E70C4CDF89B5E514992807079293\"><wsse:Username>fabiang</wsse:Username><wsse:Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText\">wrongPassword</wsse:Password><wsse:Nonce EncodingType=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary\">nFovTkBez8DceekL08FsQw==</wsse:Nonce></wsse:UsernameToken></wsse:Security>";
    private static String SOAP_RESPONSE_AUTHENTICATED = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"/><soap:Body><ns2:echoResponse xmlns:ns2=\"http://testmodels.cxf.module.mule.org/\"><text>echo</text></ns2:echoResponse></soap:Body></soap:Envelope>";
    private static String SOAP_RESPONSE_NOT_AUTHENTICATED = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><soap:Fault><faultcode xmlns:ns1=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\">ns1:FailedAuthentication</faultcode><faultstring>The security token could not be authenticated or authorized</faultstring></soap:Fault></soap:Body></soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpSecurityPolicyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSSLSessionPropagationWithCorrectPassword() throws Exception {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod("https://localhost:" + this.dynamicPort2.getNumber() + "/echo");
        this.sendRequest(true, client, method, SOAP_PROPERTY_USERNAME_TOKEN);
        MatcherAssert.assertThat((Object)client.executeMethod((HttpMethod)method), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)method.getResponseBodyAsString(), (Matcher)CoreMatchers.equalTo((Object)SOAP_RESPONSE_AUTHENTICATED));
    }

    @Test
    public void testSSLSessionPropagationWithIncorrectPassword() throws Exception {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod("https://localhost:" + this.dynamicPort2.getNumber() + "/echo");
        this.sendRequest(false, client, method, soapPropertyUsernameWrongPasswordToken);
        MatcherAssert.assertThat((Object)client.executeMethod((HttpMethod)method), (Matcher)CoreMatchers.equalTo((Object)500));
        MatcherAssert.assertThat((Object)method.getResponseBodyAsString(), (Matcher)CoreMatchers.equalTo((Object)SOAP_RESPONSE_NOT_AUTHENTICATED));
    }

    private void sendRequest(boolean correctPassword, HttpClient client, PostMethod method, String passwordSecurityPart) throws Exception {
        StringRequestEntity requestEntity = new StringRequestEntity(HttpSecurityPolicyTestCase.getSoapRequest(correctPassword, passwordSecurityPart), MediaType.PLAIN_TEXT_UTF_8.toString(), StandardCharsets.UTF_8.name());
        method.setRequestEntity((RequestEntity)requestEntity);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jax-ws-security-policy.xml"}});
    }

    private static String getSoapRequest(boolean correctPassword, String passwordSecurityPart) {
        StringBuffer request = new StringBuffer();
        request.append(SOAP_REQUEST_OPEN);
        request.append(SOAP_ENV_HEADER_OPEN);
        request.append(passwordSecurityPart);
        request.append(SOAP_ENV_HEADER_CLOSE);
        request.append(SOAP_BODY);
        request.append(SOAP_REQUEST_CLOSE);
        return request.toString();
    }
}

