/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class ProxyBindingTestCase
extends FunctionalTestCase {
    @Rule
    public final DynamicPort httpPortProxy = new DynamicPort("port1");
    @Rule
    public final DynamicPort httpPortService = new DynamicPort("port2");
    public static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
    private String getAllRequest;
    private String addArtistRequest;
    private String getAllResponse;
    private String addArtistResponse;

    protected String getConfigFile() {
        return "proxy-service-one-way-flow.xml";
    }

    @Before
    public void doSetUp() throws Exception {
        this.getAllRequest = IOUtils.getResourceAsString((String)"artistregistry-get-all-request.xml", ((Object)((Object)this)).getClass());
        this.addArtistRequest = IOUtils.getResourceAsString((String)"artistregistry-add-artist-request.xml", ((Object)((Object)this)).getClass());
        this.getAllResponse = IOUtils.getResourceAsString((String)"artistregistry-get-all-response.xml", ((Object)((Object)this)).getClass());
        this.addArtistResponse = IOUtils.getResourceAsString((String)"artistregistry-add-artist-response.xml", ((Object)((Object)this)).getClass());
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void proxyCorrectlyIdentifiesBothOperations() throws Exception {
        MuleMessage responseGetAll = muleContext.getClient().send("http://localhost:" + this.httpPortProxy.getNumber() + "/body", ProxyBindingTestCase.getTestMuleMessage((Object)this.getAllRequest), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)this.getAllResponse, (String)responseGetAll.getPayloadAsString()).identical());
        MuleMessage responseAddArtist = muleContext.getClient().send("http://localhost:" + this.httpPortProxy.getNumber() + "/body", ProxyBindingTestCase.getTestMuleMessage((Object)this.addArtistRequest), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)this.addArtistResponse, (String)responseAddArtist.getPayloadAsString()).identical());
    }
}

