/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.SensingNullRequestResponseMessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ProxyNonBlockingTestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    private static final String ECHO_SOAP_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><test xmlns=\"http://foo\"> foo </test></soap:Body></soap:Envelope>";
    private static final String GREETER_SOAP_TEST_ELEMENT_REQUEST = "<greetMe xmlns=\"http://apache.org/hello_world_soap_http/types\"><requestType>Dan</requestType></greetMe>";
    private static final String GREETER_SOAP_TEST_ELEMENT_RESPONSE = "<greetMeResponse xmlns=\"http://apache.org/hello_world_soap_http/types\"><responseType>Hello Dan</responseType></greetMeResponse>";
    private static final String GREETER_SOAP_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><greetMe xmlns=\"http://apache.org/hello_world_soap_http/types\"><requestType>Dan</requestType></greetMe></soap:Body></soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "proxy-conf-flow-httpn-nb.xml";
    }

    @Test
    public void testEchoService() throws Exception {
        this.doTest("/services/echo", ECHO_SOAP_REQUEST, ECHO_SOAP_REQUEST);
    }

    @Test
    public void testEchoProxy() throws Exception {
        this.doTest("/proxies/echo", ECHO_SOAP_REQUEST, ECHO_SOAP_REQUEST);
        this.getSensingInstance("sensingRequestResponseProcessorEcho").assertRequestResponseThreadsDifferent();
    }

    @Test
    public void testGreeterService() throws Exception {
        this.doTest("/services/greeter", GREETER_SOAP_REQUEST, GREETER_SOAP_TEST_ELEMENT_RESPONSE);
    }

    @Test
    public void testGreeterProxy() throws Exception {
        this.doTest("/proxies/greeter", GREETER_SOAP_REQUEST, GREETER_SOAP_TEST_ELEMENT_RESPONSE);
        this.getSensingInstance("sensingRequestResponseProcessorGreeter").assertRequestResponseThreadsDifferent();
    }

    private void doTest(String path, String request, String expectedResponse) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + path, ProxyNonBlockingTestCase.getTestMuleMessage((Object)request), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertThat((Object)resString, (Matcher)Matchers.containsString((String)expectedResponse));
    }

    private SensingNullRequestResponseMessageProcessor getSensingInstance(String instanceBeanName) {
        return (SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(instanceBeanName);
    }
}

