/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

@RunWith(value=Parameterized.class)
public class ProxyRPCBindingTestCase
extends FunctionalTestCase {
    @Rule
    public final DynamicPort httpPortProxy = new DynamicPort("port1");
    @Rule
    public final DynamicPort httpPortService = new DynamicPort("port2");
    public static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
    private String getAllRequest;
    private String getAllResponse;
    @Parameterized.Parameter(value=0)
    public String config;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"proxy-rpc-binding-conf.xml"}, {"proxy-rpc-binding-conf-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.config;
    }

    @Before
    public void doSetUp() throws Exception {
        this.getAllRequest = IOUtils.getResourceAsString((String)"artistregistry-get-all-request.xml", ((Object)((Object)this)).getClass());
        this.getAllResponse = IOUtils.getResourceAsString((String)"artistregistry-get-all-response.xml", ((Object)((Object)this)).getClass());
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void proxyRPCBodyPayload() throws Exception {
        MuleMessage response = muleContext.getClient().send("http://localhost:" + this.httpPortProxy.getNumber() + "/body", ProxyRPCBindingTestCase.getTestMuleMessage((Object)this.getAllRequest), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)this.getAllResponse, (String)response.getPayloadAsString()).identical());
    }

    @Test
    public void proxyRPCBodyEnvelope() throws Exception {
        MuleMessage response = muleContext.getClient().send("http://localhost:" + this.httpPortProxy.getNumber() + "/envelope", ProxyRPCBindingTestCase.getTestMuleMessage((Object)this.getAllRequest), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)this.getAllResponse, (String)response.getPayloadAsString()).identical());
    }
}

